# Übersicht der Timing & Dosierungs-Invarianten - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* **Übersicht der Timing & Dosierungs-Invarianten**

## Übersicht der Timing & Dosierungs-Invarianten

Im Folgenden werden alle definierten Invarianten für das Timing-Profil aufgelistet, jeweils mit einer kurzen Beschreibung und der Begründung für ihre Existenz. Diese Regeln sorgen für eine konsistente und eindeutige Modellierung von Dosierungszeitpunkten im FHIR-Kontext.

Neben den Timing-bezogenen Regeln existieren weitere Invarianten auf Ebene des Dosage-Elements (Profil `DosageDE` bzw. `DosageDgMP`). Diese steuern, wie strukturierte und Freitext‑Dosierungen zulässig kombiniert werden und stellen Konsistenz bei Dosiereinheiten sicher. Alle aktuell definierten Constraints sind nachfolgend aufgeführt.

### Timing-bezogene Constraints

#### TimingFrequencyCount

**Beschreibung:**
 Die Häufigkeit (`frequency`) muss mit der Anzahl der angegebenen Zeitpunkte (`timeOfDay` oder `when`) übereinstimmen, abhängig davon, welche Felder gesetzt sind.

**Warum?**
 Diese Regel stellt sicher, dass die Anzahl der Dosierungen pro Periode korrekt mit den angegebenen Zeitpunkten übereinstimmt. So wird verhindert, dass widersprüchliche oder unklare Dosierungsangaben entstehen.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-01-of-05](./MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-01-of-05.md) | 1 Stück |   |   | 2 | 1 | d |   |   | MORN |   |
| [MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-02-of-05](./MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-02-of-05.md) | 1 Stück |   |   | 2 | 1 | d |   | 08:00:00 |   |   |
| [MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-03-of-05](./MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-03-of-05.md) | 2 Stück |   |   | 3 | 1 | wk | tue, thu |   |   |   |
| [MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-04-of-05](./MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-04-of-05.md) | 1 Stück2 Stück |   |   | 32 | 2 | d |   | 08:00:00, 20:00:0010:00:00, 14:00:00, 22:00:00 |   |   |
| [MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-05-of-05](./MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-05-of-05.md) | 1 Stück |   |   | 3 | 1 | wk | mon, fri |   | MORN | {'system': 'http://unitsofmeasure.org', 'value': 3, 'code': 'wk', 'unit': 'Woche(n)'} |

#### TimingPeriodUnit

**Beschreibung:**
 Wenn Wochentage (`dayOfWeek`) angegeben sind, muss die Zeiteinheit (`periodUnit`) "Woche" (`wk`) sein, andernfalls "Tag" (`d`).

**Warum?**
 Dadurch wird sichergestellt, dass die Zeiteinheit zur Angabe der Dosierungsperiode konsistent zu den verwendeten Feldern passt und keine Missverständnisse bei der Interpretation entstehen.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-01-of-05](./MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-01-of-05.md) | 1 Stück |   |   | 1 | 1 | wk |   |   | MORN |   |
| [MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-02-of-05](./MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-02-of-05.md) | 1 Stück |   |   | 1 | 1 | wk |   | 08:00:00 |   |   |
| [MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-03-of-05](./MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-03-of-05.md) | 2 Stück |   |   | 1 | 1 | d | tue |   |   |   |
| [MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-04-of-05](./MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-04-of-05.md) | 1 Stück |   |   | 2 | 1 | d | mon, fri |   | MORN | {'system': 'http://unitsofmeasure.org', 'value': 3, 'code': 'wk', 'unit': 'Woche(n)'} |
| [MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-05-of-05](./MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-05-of-05.md) | 1 Stück2 Stück |   |   | 2 | 1 | wkd | mon, fri |   | MORNNOON | {'system': 'http://unitsofmeasure.org', 'value': 3, 'code': 'wk', 'unit': 'Woche(n)'} |

#### TimingOnlyOneType

**Beschreibung:**
 Es darf pro Dosierung nur eine Art der Zeitangabe verwendet werden (z.B. ausschließlich `4-Schema`, `TimeOfDay`, `DayOfWeek`, `Interval`, Kombinationen wie `DayOfWeek+TimeOfDay` oder `Interval+TimeOfDay`).

**Warum?**
 Diese Einschränkung verhindert Mehrdeutigkeiten und sorgt dafür, dass die Dosierungszeitpunkte eindeutig interpretierbar bleiben.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08](./MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md) | 1 Stück1 Stück |   |   | 1 | 1 | dwk | mon |   | EVE |   |
| [MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08](./MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md) | 1 Stück1 Stück |   |   | 1 | 1 | d |   |   | NOON |   |
| [MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08](./MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md) | 1 Stück1 Stück |   |   | 1 | 1 | dwk | fri | 07:00:00 |   |   |
| [MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08](./MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08.md) | 1 Stück1 Stück |   |   | 1 | 1 | d |   | 12:00:00 |   |   |
| [MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08](./MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08.md) | 1 Stück1 Stück |   |   | 1 | 1 | wkd | tue |   |   |   |

#### TimingOnlyOneWhen

**Beschreibung:**
 Es darf nicht derselbe Zeitraum des Tages (`when`) in mehreren Dosierungsinstanzen vorkommen.

**Warum?**
 Dadurch wird verhindert, dass Dosierungen mehrfach für denselben Zeitraum angegeben werden, was zu Überdosierung oder Verwirrung führen könnte.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen](./MedicationRequest-Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen.md) | 1 Stück2 Stück |   |   | 1 | 1 | d |   |   | MORNMORN, EVE |   |
| [MedicationRequest-Invalid-multiple-07-of-10-C-TimingOnlyOneWhen](./MedicationRequest-Invalid-multiple-07-of-10-C-TimingOnlyOneWhen.md) | 1 Stück2 Stück |   |   | 12 | 2 | d |   |   | MORNMORN, EVE |   |

#### TimingOnlyWhenOrTimeOfDay

**Beschreibung:**
 Es darf nicht die Tageszeit `timeOfDay` und der Zeitraum des Tages `when` in mehreren Dosierungsinstanzen gleichzeitig vorkommen.

**Warum?**
 Dadurch wird verhindert, dass Dosierungen gemischte Schemata anzeigen.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01](./MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01.md) | 1 Stück1 Stück |   |   | 1 | 1 | d |   | 08:00:00 | MORN |   |

#### TimingOnlyOneTimeOfDay

**Beschreibung:**
 Es darf nicht dieselbe Tageszeit (`timeOfDay`) in mehreren Dosierungsinstanzen vorkommen.

**Warum?**
 Auch hier wird sichergestellt, dass Dosierungen nicht mehrfach für dieselbe Uhrzeit definiert werden, um Redundanzen und Fehler zu vermeiden.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay](./MedicationRequest-Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay.md) | 2 Stück1 Stück |   |   | 12 | 1 | d |   | 08:00:0008:00:00, 14:00:00 |   |   |
| [MedicationRequest-Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay](./MedicationRequest-Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay.md) | 1 Stück2 Stück |   |   | 1 | 2 | d |   | 08:00:00 |   |   |

#### TimingOnlyOneDayOfWeek

**Beschreibung:**
 Es darf nicht derselbe Wochentag (`dayOfWeek`) in mehreren Dosierungsinstanzen vorkommen.

**Warum?**
 Dies verhindert doppelte Einträge für denselben Wochentag und stellt eine eindeutige Zuordnung sicher.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek](./MedicationRequest-Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek.md) | 1 Stück2 Stück |   |   | 1 | 1 | wk | mon |   |   |   |

#### TimingOnlyOneBounds

**Beschreibung:**
 Für die Dauer (`bounds` vom Typ `Duration`) dürfen pro Ressource nur ein Wert und ein Code vorkommen.

**Warum?**
 So wird ausgeschlossen, dass mehrere unterschiedliche Zeiträume für eine Dosierung angegeben werden, was die Interpretation erschweren würde.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-multiple-10-of-10-C-TimingOnlyOneBounds](./MedicationRequest-Invalid-multiple-10-of-10-C-TimingOnlyOneBounds.md) | 1 Stück2 Stück |   |   | 1 | 1 | d |   | 08:00:0020:00:00 |   | {'system': 'http://unitsofmeasure.org', 'value': 2, 'code': 'wk', 'unit': 'Woche(n)'}{'system': 'http://unitsofmeasure.org', 'value': 3, 'code': 'wk', 'unit': 'Woche(n)'} |

#### TimingIntervalOnlyOneFrequency

**Beschreibung:**
 Bei Intervallangaben darf es nur eine Dosierungsinstanz geben.

**Warum?**
 Dadurch wird verhindert, dass ein Intervall mehrfach beschrieben wird, was zu widersprüchlichen Angaben führen könnte.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency](./MedicationRequest-Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency.md) | 1 Stück2 Stück |   |   | 1 | 23 | d |   |   |   |   |

#### TimingOnlyOnePeriodForDayOfWeek

**Beschreibung:**
 Wenn für einen Wochentag mehrere Einträge existieren, müssen sich deren Zeitangaben (`when`/`timeOfDay`) unterscheiden.

**Warum?**
 Dies stellt sicher, dass für jeden Wochentag die Dosierungszeitpunkte eindeutig sind und keine Dopplungen auftreten.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek](./MedicationRequest-Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) | 1 Stück2 Stück |   |   | 21 | 1 | d | mon, frimon, sat |   | MORN, EVEMORN |   |
| [MedicationRequest-Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek](./MedicationRequest-Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) | 1 Stück2 Stück |   |   | 21 | 1 | d | mon, frimon, sat | 08:00:00, 12:00:0008:00:00 |   |   |

#### TimingOnlyOneTimeForInterval

**Beschreibung:**
 Bei Intervallangaben mit Zeitpunkten (`when` oder `timeOfDay`) dürfen die Zeitangaben nicht mehrfach vorkommen und die Periodenangaben müssen eindeutig sein.

**Warum?**
 Damit wird verhindert, dass für ein Intervall mehrere widersprüchliche Zeitpunkte oder Perioden definiert werden.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval](./MedicationRequest-Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval.md) | 1 Stück2 Stück |   |   | 12 | 12 | d |   |   | MORNNOON, EVE |   |
| [MedicationRequest-Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval](./MedicationRequest-Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval.md) | 1 Stück2 Stück |   |   | 1 | 23 | d |   | 08:00:0020:00:00 |   |   |

#### TimingBoundsUnitMatchesCode

**Beschreibung:**
 Die Einheit (`boundsDuration.unit`) muss zum UCUM‑Code (`boundsDuration.code`) passen; z. B. `wk` nur mit „Woche(n)“, `d` nur mit „Tag(e)“, `mo` nur mit „Monat(e)“, `a` nur mit „Jahr(e)“.

**Warum?**
 Verhindert widersprüchliche Angaben wie `code='wk'` mit `unit='Tag(e)'`.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01](./MedicationRequest-Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01.md) | 1 Stück |   |   | 1 | 2 | d |   |   |   | {'system': 'http://unitsofmeasure.org', 'value': 3, 'code': 'wk', 'unit': 'Tag(e)'} |

#### TimingSingleDosageForTimeOfDay

**Beschreibung:**
 Wenn nur `timeOfDay` verwendet wird und täglich dosiert wird, sind mehrere Tageszeiten in einem einzigen `Dosage`‑Element zu modellieren. Mehrere `Dosage`‑Elemente sind nur zulässig, wenn sich die Dosis (Wert) unterscheidet.

**Warum?**
 Verhindert unnötige Aufsplitterung gleichartiger Dosierungen und sorgt für eine klare, eindeutige Modellierung der Tageszeiten.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01](./MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01.md) | 1 Stück1 Stück |   |   | 1 | 1 | d |   | 08:00:0020:00:00 |   |   |

#### TimingSingleDosageForWhen

**Beschreibung:**
 Wenn nur `when` verwendet wird und täglich dosiert wird, sind mehrere Zeitabschnitte des Tages in einem einzigen `Dosage`‑Element zu modellieren. Mehrere `Dosage`‑Elemente sind nur zulässig, wenn sich die Dosis (Wert) unterscheidet.

**Warum?**
 Verhindert unnötige Aufsplitterung gleichartiger Dosierungen und sorgt für eine klare, eindeutige Modellierung der Tagesabschnitte.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01](./MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01.md) | 1 Stück1 Stück |   |   | 1 | 1 | d |   |   | MORNEVE |   |

### Dosage-bezogene Constraints

Die folgenden Invarianten beziehen sich auf das Dosage-Element insgesamt (nicht nur auf `timing.repeat`). Sie wirken über alle Dosierungsinstanzen einer Ressource (z. B. alle `dosageInstruction` eines `MedicationRequest`).

#### DosageStructuredOrFreeText / DosageStructuredOrFreeTextWarning

**Beschreibung:**
 Eine Dosierungsangabe darf entweder vollständig strukturiert (mit `timing` und/oder `doseAndRate`) oder ausschließlich als Freitext (`text`) vorliegen - eine Mischung ist nicht zulässig.

**Hinweis zur Ausprägung:**
 Im generischen Profil `DosageDE` ist dies als Warnung (`warning`) modelliert (`DosageStructuredOrFreeTextWarning`), im dgMP‑Spezialprofil (`DosageDgMP`) als Fehler (`error`, Invariante `DosageStructuredOrFreeText`). Implementierungen sollten die strukturierte Variante bevorzugen und Freitext nur verwenden, wenn eine strukturierte Abbildung nicht möglich ist.

**Warum?**
 Verhindert widersprüchliche oder doppelte Informationsquellen (Freitext vs. Struktur) und erleichtert automatische Verarbeitung (z. B. Generierung patientenverständlicher Texte).

Beispiele (Fehlerfall – Mischform aus Text und Struktur):

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02](./MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02.md) | 1 Stück |   |   | 1 | 1 | d |   |   | MORN |   |
| [MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02](./MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02.md) | 2 Stück |   |   |   |   |   |   |   |   |   |
| [MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01](./MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01.md) |   |   |   |   |   |   |   |   |   |   |

Gültige Varianten (Warnungskontext – nur Text oder nur Struktur):

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01](./MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01.md) |   |   |   |   |   |   |   |   |   |   |

#### DosageStructuredRequiresBoth

**Beschreibung:**
 Wenn eine strukturierte Dosierung angegeben wird, müssen sowohl zeitliche Angaben (`timing`) als auch die Dosis (`doseAndRate`) vorhanden sein.

**Warum?**
 Stellt sicher, dass eine strukturierte Dosierung hinreichend vollständig ist, um automatisiert interpretiert werden zu können (Zeit + Menge).

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02](./MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02.md) |   |   |   | 1 | 1 | d |   |   | MORN |   |
| [MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02](./MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02.md) | 1 Stück |   |   |   |   |   |   |   |   |   |

#### DosageStructuredRequiresGeneratedText

**Beschreibung:**
 Liegt eine strukturierte Dosierung vor (strukturierte Elemente befüllt, Freitext leer), muss die Extension `GeneratedDosageInstructionsMeta` existieren sowie genau eine der FHIR R5 RenderedDosageInstruction-Extensions passend zur Ressource (MedicationRequest/Dispense/Statement).

**Warum?**
 Dokumentiert, dass ein (maschinen-)generierter, patientenlesbarer Dosierungstext verfügbar ist und stellt die Nachvollziehbarkeit der Generierung sicher.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01](./MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01.md) | 1 Stück |   |   | 1 | 1 | d |   |   | MORN |   |

#### FreeTextMatchesRenderedText

**Beschreibung:**
 Wenn eine Dosierung als reiner Freitext angegeben ist (nur `text`, kein `timing`/`doseAndRate`), muss der Wert in `dosageInstruction.text` exakt mit dem Wert in der Extension `renderedDosageInstruction` übereinstimmen.

**Warum?**
 Verhindert Inkonsistenzen zwischen der Freitextangabe und der gerenderten Dosierungsanweisung. Dies stellt sicher, dass der vom Anwender eingegebene Freitext konsistent in der Extension für die Darstellung übernommen wird.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01](./MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01.md) |   |   |   |   |   |   |   |   |   |   |

#### FreeTextSingleDosageOnly

**Beschreibung:**
 Wenn eine Dosierung als reiner Freitext angegeben ist (nur `text`, kein `timing`/`doseAndRate`), darf in der Ressource insgesamt nur genau ein `Dosage`‑Eintrag vorkommen.

**Warum?**
 Verhindert widersprüchliche oder doppelte Freitextangaben, die nicht automatisch zusammengeführt werden können. Fördert eindeutige, konsolidierte Freitext‑Anweisungen, wenn keine strukturierte Modellierung erfolgt.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01](./MedicationRequest-Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01.md) |   |   |   |   |   |   |   |   |   |   |

#### DosageDoseUnitSameCode

**Beschreibung:**
 Alle Dosierungsinstanzen innerhalb derselben Ressource müssen dieselbe Dosiereinheit (Code) verwenden.

**Warum?**
 Verhindert inkonsistente oder schwer vergleichbare Einträge (z. B. Mischung von Einheiten wie Stück vs. mg) und reduziert Interpretationsfehler bei Summierung oder Darstellung.

Folgende Beispiele sind nicht valide, da sie den Constraint brechen:

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01](./MedicationRequest-Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01.md) | 1 Stück500 mg |   |   | 1 | 1 | d |   |   | MORNEVE |   |

#### DosageWarnungViererschemaInText

**Beschreibung:**
 Warnung, wenn ein klassisches 4-Schema (z. B. Darstellung wie "1-0-1-0") im Freitext angegeben wird, obwohl eine strukturierte Abbildung möglich wäre.

**Warum?**
 Ermutigt zur strukturierten Modellierung der Einnahmezeiten anstelle rein schematischer Textdarstellungen, verbessert maschinelle Auswertbarkeit und Textgenerierung.

Gültige Beispiele (Warnungskontext – Freitext enthält 4-Schema):

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [MedicationRequest-Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01](./MedicationRequest-Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01.md) |   |   |   |   |   |   |   |   |   |   |

