# FHIR Summary - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* **FHIR Summary**

## FHIR Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |
| [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |
| [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md) | Dieses Profil dient ausschließlich der Validierung des Implementation Guides und ist nicht für den produktiven Einsatz gedacht. Stattdessen sollte das jeweils passende Dosage-Profil direkt in das eigene Profil eingebunden werden. |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Dosage DE](StructureDefinition-DosageDE.md) | Gibt an, wie das Medikament eingenommen oder verabreicht wurde bzw. eingenommen oder verabreicht werden soll - entweder selbst vom Patienten eingenommen oder bei Fremdverabreichung von Dritten (z. B. Leistungserbringer, Angehörige) verabreicht. |
| [Dosage dgMP](StructureDefinition-DosageDgMP.md) | Gibt an, wie das Medikament vom Patienten im Kontext dgMP eingenommen wird/wurde oder eingenommen werden soll. |
| [Timing DE](StructureDefinition-TimingDE.md) | Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. |
| [Timing dgMP](StructureDefinition-TimingDgMP.md) | Beschreibt ein Ereignis, das mehrfach auftreten kann. Zeitpläne werden verwendet, um festzuhalten, wann etwas geplant, erwartet oder angefordert ist. Die häufigste Anwendung ist in Dosierungsanweisungen für Medikamente. Sie werden aber auch für die Planung verschiedener Versorgungsleistungen genutzt und können zur Dokumentation von bereits erfolgten oder laufenden Aktivitäten verwendet werden. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Generated Dosage Instructions Meta](StructureDefinition-GeneratedDosageInstructionsMeta.md) | Diese Extension enthält die Metainformationen zur generierten textuellen Dosierungsanweisung, die auf Basis der bereitgestellten strukturierten Dosierungsinformationen erstellt wurde. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Algorithm Language Codes dgMP ValueSet](ValueSet-AlgorithmLanguageCodesDgMP.md) | Dieses ValueSet enthält die im dgMP unterstützten Sprachen für Algorithmen, die in der Dosierung verwendet werden können. |
| [Dosage DoseQuantity ValueSet](ValueSet-DosageDoseQuantityDE.md) | Diese ValueSet enthält Konzepte für die Dosierungseinheit in der Dosiermenge. |
| [Duration UnitsOfTime dgMP ValueSet](ValueSet-DosageUnitsOfTimeDgMP.md) | Dieses ValueSet enthält dgMPV DurationUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung |
| [EDQM Unit of Presentation ValueSet](ValueSet-EDQMUnitOfPresentation.md) | ValueSet Einheit der Darreichungsform gemäß EDQM, UOP, siehe https://standardterms.edqm.eu/# |
| [Period UnitsOfTime dgMP ValueSet](ValueSet-PeriodUnitsOfTimeDgMP.md) | Dieses ValueSet enthält dgMP PeriodUnit Zeiteinheiten aus dem UCUM-CodeSystem in deutscher Übersetzung |
| [Timing When dgMP](ValueSet-TimingWhenDgMP.md) | Tageszeiten für Zeitmuster |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Bug Test: Empty timeOfDay/when/dayOfWeek lists](MedicationRequest-Example-MR-Bug-EmptyLists.md) | Test case with empty arrays that might cause incorrect schema detection due to non-strict boolean logic. |
| [Bug Test: Multiple timeOfDay Daily](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Daily.md) | Test case for TimeOfDay schema with multiple times. Should show all times: 08:00, 14:00, and 22:00. |
| [Bug Test: Multiple timeOfDay with DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-DayOfWeek.md) | Test case for multiple timeOfDay entries in DayOfWeek+Time schema. Should show both 09:00 and 21:00 times. |
| [Bug Test: Multiple timeOfDay with Interval](MedicationRequest-Example-MR-Bug-MultipleTimeOfDay-Interval.md) | Test case showing the bug where only first timeOfDay is processed in Interval+Time schema. Should show both 08:00 and 20:00 times. |
| [Bug Test: Multiple when codes with DayOfWeek](MedicationRequest-Example-MR-Bug-MultipleWhen-DayOfWeek.md) | Test case for multiple when codes in DayOfWeek+When schema. Should show both morning and evening patterns. |
| [Bug Test: Multiple when codes with Interval](MedicationRequest-Example-MR-Bug-MultipleWhen-Interval.md) | Test case showing the bug where only first when code is processed in Interval+Time schema. Should show both morning and evening. |
| [Example-MR-Dosage-1000](MedicationRequest-Example-MR-Dosage-1000.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-0-0 dar |
| [Example-MR-Dosage-1010](MedicationRequest-Example-MR-Dosage-1010.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 dar |
| [Example-MR-Dosage-1010](MedicationRequest-Example-MR-Dosage-1010-10-Days.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 für 10 Wochen dar |
| [Example-MR-Dosage-1010-Unsorted](MedicationRequest-Example-MR-Dosage-1010-Unsorted.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-1-0 unsortiert dar |
| [Example-MR-Dosage-10120](MedicationRequest-Example-MR-Dosage-10120.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1-0-0.5-0 dar |
| [Example-MR-Dosage-1020](MedicationRequest-Example-MR-Dosage-1020.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 dar |
| [Example-MR-Dosage-1020](MedicationRequest-Example-MR-Dosage-1220.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-2-2-0 dar |
| [Example-MR-Dosage-1020-Unordered](MedicationRequest-Example-MR-Dosage-1020-Unordered.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 unsortiert dar |
| [Example-MR-Dosage-1111](MedicationRequest-Example-MR-Dosage-1111.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-1-1-1 dar |
| [Example-MR-Dosage-2t-1t](MedicationRequest-Example-MR-Dosage-weekday-2t-1t.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags 2 Stück, Donnerstags 1 Stück dar |
| [Example-MR-Dosage-Freetext](MedicationRequest-Example-MR-Dosage-Freetext.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Freitext-Dosierung dar |
| [Example-MR-Dosage-UnitStueck-1020](MedicationRequest-Example-MR-Dosage-UnitStueck-1020.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-2-0 und kodierter Einheit 'Stück' dar |
| [Example-MR-Dosage-UnitTasse-1000](MedicationRequest-Example-MR-Dosage-UnitTasse-1000.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 1-0-0-0 und kodierter Einheit 'Stück' dar |
| [Example-MR-Dosage-UnitTr-1000](MedicationRequest-Example-MR-DosageTr-1000.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 20-0-0-0 und kodierter Einheit 'Tropfen' dar |
| [Example-MR-Dosage-comb-dayofweek-1](MedicationRequest-Example-MR-Dosage-comb-dayofweek-1.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1-0-1-0 dar |
| [Example-MR-Dosage-comb-dayofweek-2](MedicationRequest-Example-MR-Dosage-comb-dayofweek-2.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1-0-2-0 dar |
| [Example-MR-Dosage-comb-dayofweek-3](MedicationRequest-Example-MR-Dosage-comb-dayofweek-3.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags und Freitags 1 Stück Morgens und 2 Stück Mittags (1-1-0-0) - für 3 Wochen dar |
| [Example-MR-Dosage-comb-dayofweek-unsorted](MedicationRequest-Example-MR-Dosage-comb-dayofweek-unsorted.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von unsortierten Wochentagen dar |
| [Example-MR-Dosage-comb-interval-1](MedicationRequest-Example-MR-Dosage-comb-interval-1.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 18:00 Uhr dar |
| [Example-MR-Dosage-comb-interval-2](MedicationRequest-Example-MR-Dosage-comb-interval-2.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 x pro Woche 1 Stück morgens dar |
| [Example-MR-Dosage-comb-interval-3](MedicationRequest-Example-MR-Dosage-comb-interval-3.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und jeden 2. Tag 1 Stück um 20:00 Uhr dar |
| [Example-MR-Dosage-comb-interval-4](MedicationRequest-Example-MR-Dosage-comb-interval-4.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 & 20:00 Uhr und jeden 2. Tag 1 Stück um 08:00, 14:00 und 22:00 Uhr dar |
| [Example-MR-Dosage-interval-2d](MedicationRequest-Example-MR-Dosage-interval-2d-bound.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Alle 2 Tage 2 Stück für 6 Wochen dar |
| [Example-MR-Dosage-interval-2wk](MedicationRequest-Example-MR-Dosage-interval-2wk.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück alle 2 Wochen dar |
| [Example-MR-Dosage-interval-3d](MedicationRequest-Example-MR-Dosage-interval-3d.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Alle 3 Tage 1 Stück dar |
| [Example-MR-Dosage-interval-4times-d](MedicationRequest-Example-MR-Dosage-interval-4times-d.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 4 x 1 Stück pro Tag dar |
| [Example-MR-Dosage-interval-8d](MedicationRequest-Example-MR-Dosage-interval-8d.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück alle 8 Tage dar |
| [Example-MR-Dosage-tod-1t-8am](MedicationRequest-Example-MR-Dosage-tod-1t-8am.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück um 08:00 |
| [Example-MR-Dosage-tod-2-12am](MedicationRequest-Example-MR-Dosage-tod-2-12am.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 2 Stück um 12:00 Uhr |
| [Example-MR-Dosage-tod-multi](MedicationRequest-Example-MR-Dosage-tod-multi.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 8 Uhr: 2 Stück - 11 Uhr: 1 Stück - 14 Uhr: 1 Stück - 17 Uhr: 1 Stück - 20 Uhr: 1 Stück - 23 Uhr: 1 Stück dar |
| [Example-MR-Dosage-tod-multi-bound](MedicationRequest-Example-MR-Dosage-tod-multi-bound.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung 8 Uhr: 2 Stück - 11 Uhr: 1 Stück - 14 Uhr: 1 Stück - 17 Uhr: 1 Stück - 20 Uhr: 1 Stück - 23 Uhr: 1 Stück, für 10 Tage |
| [Example-MR-Dosage-tod-unsorted](MedicationRequest-Example-MR-Dosage-tod-unsorted.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von 1 Stück und unsortierten Zeiten dar |
| [Example-MR-Dosage-weekday-2t](MedicationRequest-Example-MR-Dosage-weekday-2t.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Dienstags und Donnerstags je 2 Stück dar |
| [Example-MR-Dosage-weekday-2t-bound](MedicationRequest-Example-MR-Dosage-weekday-2t-bound.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Montags 2 Tabl. für 10 Wochen dar |
| [Example-MR-Dosage-weekday-3t](MedicationRequest-Example-MR-Dosage-weekday-3t.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Dienstags, Donnerstags und Samstag je 2 Stück dar |
| [Example-MR-Dosage-weekday-unsorted](MedicationRequest-Example-MR-Dosage-weekday-unsorted.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von unsortierten Wochentagen je 2 Stück dar |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-01-of-12-FreqPeriod-When.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-02-of-12-FreqPeriod-ToD-DayOfWeek.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-03-of-12-FreqPeriod-When-DayOfWeek.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-04-of-12-FreeText-and-structured.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-05-of-12-multiple-types.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-06-of-12-multiple-dosagecodes.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-07-of-12-timing-no-dose.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-09-of-12-C-TimingOnlyOneTimeForInterval.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-10-of-12-When-DiffPeriodU.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-11-of-12-C-TimingOnlyOneWhen.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-12-of-12-C-TimingOnlyOneDayOfWeek.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresGeneratedText-01-of-01.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-01-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-02-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-03-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-04-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingFrequencyCount-05-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-01-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-02-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-03-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-04-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage](MedicationRequest-Invalid-Dosage-C-TimingPeriodUnit-05-of-05.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Invalid Dosage - FreeText doesn't match renderedDosageInstruction](MedicationRequest-Invalid-Dosage-C-FreeTextMatchesRenderedText-01-of-01.md) | Invalid: Freitext-Dosierung vorhanden, aber der Wert in dosageInstruction.text stimmt nicht mit renderedDosageInstruction überein. |
| [Invalid Dosage - FreeText must be single](MedicationRequest-Invalid-Dosage-C-FreeTextSingleDosageOnly-01-of-01.md) | Invalid: Freitextdosierung vorhanden, aber mehr als ein Dosage-Element vorhanden. |
| [Invalid boundsDuration unit/code mismatch](MedicationRequest-Invalid-Dosage-C-TimingBoundsUnitMatchesCode-01-of-01.md) | boundsDuration.code 'wk' with unit 'Tag(e)' |
| [Invalid: dayOfWeek + interval](MedicationRequest-Invalid-C-TimingOnlyOneType-05-of-08.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [Invalid: dose without timing](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-02-of-02.md) | CAVE: Validation example - doseAndRate exists but timing missing. |
| [Invalid: mixed dose units](MedicationRequest-Invalid-Dosage-C-DosageDoseUnitSameCode-01-of-01.md) | CAVE: Validation example - two dosageInstructions use different dose unit codes. |
| [Invalid: split timeOfDay into two dosages (same period/dose)](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForTimeOfDay-01-of-01.md) | Zwei Dosages mit identischem Intervall und Dosis, jeweils eine Uhrzeit - sollte zu einer Dosage zusammengeführt werden. |
| [Invalid: split when into two dosages (same period/dose)](MedicationRequest-Invalid-Dosage-C-TimingSingleDosageForWhen-01-of-01.md) | Zwei Dosages mit identischem Intervall und Dosis, jeweils ein Zeitraum (MORN/EVE) - sollte zu einer Dosage zusammengeführt werden. |
| [Invalid: text + doseAndRate](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-02-of-02.md) | CAVE: Validation example - contains both text and doseAndRate (should be either structured OR text). |
| [Invalid: text + timing](MedicationRequest-Invalid-Dosage-C-DosageStructuredOrFreeText-01-of-02.md) | CAVE: Validation example - contains both text and timing (should be either structured OR text). |
| [Invalid: timeOfDay + dayOfWeek](MedicationRequest-Invalid-C-TimingOnlyOneType-03-of-08.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [Invalid: timeOfDay + interval](MedicationRequest-Invalid-C-TimingOnlyOneType-04-of-08.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [Invalid: timing without dose](MedicationRequest-Invalid-Dosage-C-DosageStructuredRequiresBoth-01-of-02.md) | CAVE: Validation example - timing exists but doseAndRate missing. |
| [Invalid: when + dayOfWeek](MedicationRequest-Invalid-C-TimingOnlyOneType-01-of-08.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [Invalid: when + interval](MedicationRequest-Invalid-C-TimingOnlyOneType-02-of-08.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [Invalid: when + timeOfDay](MedicationRequest-Invalid-C-TimingOnlyWhenOrTimeOfDay-01-of-01.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for allowed Permutations |
| [MedicationDispense Dosage Example - 4-Schema](MedicationDispense-MD-Dosage-1020.md) | Example showing 4-Schema pattern in MedicationDispense |
| [MedicationDispense Dosage Example - Bounds and Decimals](MedicationDispense-MD-Dosage-Bounds-Decimals.md) | Example showing bounds and decimal doses in MedicationDispense |
| [MedicationDispense Dosage Example - DayOfWeek and Time](MedicationDispense-MD-Dosage-DayOfWeek-Time.md) | Example showing DayOfWeek and Time pattern in MedicationDispense |
| [MedicationDispense Dosage Example - FreeText](MedicationDispense-MD-Dosage-Freetext.md) | Example showing FreeText pattern in MedicationDispense |
| [MedicationDispense Dosage Example - Interval and Time](MedicationDispense-MD-Dosage-Interval-Time.md) | Example showing Interval and Time pattern in MedicationDispense |
| [MedicationRequest Dosage Example - 4-Schema Evening Only](MedicationRequest-MR-Dosage-4schema-evening-only.md) | Example showing 4-Schema pattern with only evening dose (0-0-1-0) |
| [MedicationRequest Dosage Example - 4-Schema Night Only](MedicationRequest-MR-Dosage-4schema-night-only.md) | Example showing 4-Schema pattern with only night dose (0-0-0-1) |
| [MedicationRequest Dosage Example - 4-Schema Noon Only](MedicationRequest-MR-Dosage-4schema-noon-only.md) | Example showing 4-Schema pattern with only noon dose (0-1-0-0) |
| [MedicationRequest Dosage Example - 4-Schema with ml Units](MedicationRequest-MR-Dosage-4schema-ml-units.md) | Example showing 4-Schema pattern with ml units instead of Stück |
| [MedicationRequest Dosage Example - DayOfWeek Mixed Doses](MedicationRequest-MR-Dosage-weekday-mixed-doses.md) | Example showing different doses on different days of the week |
| [MedicationRequest Dosage Example - FreeText German Characters](MedicationRequest-MR-Dosage-freetext-german-chars.md) | Example showing FreeText with German special characters and complex text |
| [MedicationRequest Dosage Example - Interval with When Codes](MedicationRequest-MR-Dosage-interval-when-3d.md) | Example showing interval dosing with when codes instead of timeOfDay |
| [MedicationRequest Dosage Example - Monthly Interval](MedicationRequest-MR-Dosage-interval-monthly.md) | Example showing interval dosing with monthly period |
| [MedicationRequest Dosage Example - Multiple Days with TimeOfDay](MedicationRequest-MR-Dosage-multiple-day-time.md) | Example showing multiple dayOfWeek + timeOfDay combination |
| [MedicationRequest Dosage Example - Single Day with TimeOfDay](MedicationRequest-MR-Dosage-single-day-time.md) | Example showing minimal dayOfWeek + timeOfDay combination |
| [MedicationRequest Dosage Example - TimeOfDay Mixed Doses](MedicationRequest-MR-Dosage-tod-mixed-doses.md) | Example showing different doses at different times of day |
| [MedicationStatement Dosage Example - 4-Schema](MedicationStatement-MS-Dosage-1010.md) | Example showing 4-Schema pattern in MedicationStatement |
| [MedicationStatement Dosage Example - DayOfWeek](MedicationStatement-MS-Dosage-DayOfWeek.md) | Example showing DayOfWeek pattern in MedicationStatement |
| [MedicationStatement Dosage Example - FreeText](MedicationStatement-MS-Dosage-Freetext.md) | Example showing FreeText pattern in MedicationStatement |
| [MedicationStatement Dosage Example - Interval](MedicationStatement-MS-Dosage-Interval.md) | Example showing Interval pattern in MedicationStatement |
| [MedicationStatement Dosage Example - TimeOfDay](MedicationStatement-MS-Dosage-TimeOfDay.md) | Example showing TimeOfDay pattern in MedicationStatement |
| [Two Interval Dosages](MedicationRequest-Invalid-multiple-06-of-10-C-TimingIntervalOnlyOneFrequency.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von jeden 2. Tag 1 Stück und 3. Tag 2 Stück dar |
| [Two dosages with the same period of day](MedicationRequest-Invalid-multiple-01-of-10-when.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Two dosages with the same period of day on the same day](MedicationRequest-Invalid-multiple-04-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Two dosages with the same time of day](MedicationRequest-Invalid-multiple-02-of-10-C-TimingOnlyOneTimeOfDay.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Two dosages with the same time of day on the same day](MedicationRequest-Invalid-multiple-05-of-10-C-TimingOnlyOnePeriodForDayOfWeek.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for invalid Permutations |
| [Two interval Dosages different boundsDuration](MedicationRequest-Invalid-multiple-10-of-10-C-TimingOnlyOneBounds.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung mit verschiedener Dauer dar |
| [Two interval Dosages same period of day](MedicationRequest-Invalid-multiple-07-of-10-C-TimingOnlyOneWhen.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar |
| [Two interval Dosages same time](MedicationRequest-Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar |
| [Two interval Dosages same time](MedicationRequest-Invalid-multiple-09-of-10-C-TimingOnlyOneTimeForInterval.md) | Dieses Beispiel stellt eine Medikationsanforderung mit einer Dosierung von Jeden 2. Tag 1 Stück um 08:00 Uhr und 1 Stück um 10:00 Uhr dar |
| [Unsupported Dosage 1 AdditionalInstruction](MedicationRequest-MR-Unsupported-Dosage-11-of-20-AdditionalInstruction.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 BoundsPeriod](MedicationRequest-MR-Unsupported-Dosage-17-of-20-BoundsPeriod.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 BoundsRange](MedicationRequest-MR-Unsupported-Dosage-18-of-20-BoundsRange.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Count](MedicationRequest-MR-Unsupported-Dosage-01-of-20-Count.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Count](MedicationRequest-MR-Unsupported-Dosage-15-of-20-Count.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 CountMax](MedicationRequest-MR-Unsupported-Dosage-16-of-20-CountMax.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 DoseRange](MedicationRequest-MR-Unsupported-Dosage-07-of-20-DoseRange.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Event](MedicationRequest-MR-Unsupported-Dosage-20-of-20-Event.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 MaxDosePerAdministration](MedicationRequest-MR-Unsupported-Dosage-13-of-20-MaxDosePerAdministration.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 MaxDosePerLifetime](MedicationRequest-MR-Unsupported-Dosage-14-of-20-MaxDosePerLifetime.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 MaxDosePerPeriod](MedicationRequest-MR-Unsupported-Dosage-12-of-20-MaxDosePerPeriod.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Method](MedicationRequest-MR-Unsupported-Dosage-04-of-20-Method.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Offset](MedicationRequest-MR-Unsupported-Dosage-19-of-20-Offset.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 RateQuantity](MedicationRequest-MR-Unsupported-Dosage-08-of-20-RateQuantity.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 RateRange](MedicationRequest-MR-Unsupported-Dosage-09-of-20-RateRange.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 RateRatio](MedicationRequest-MR-Unsupported-Dosage-10-of-20-RateRatio.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Route](MedicationRequest-MR-Unsupported-Dosage-05-of-20-Route.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 Site](MedicationRequest-MR-Unsupported-Dosage-06-of-20-Site.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 asNeededBoolean](MedicationRequest-MR-Unsupported-Dosage-02-of-20-asNeededBoolean.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Unsupported Dosage 1 asNeededCodeableConcept](MedicationRequest-MR-Unsupported-Dosage-03-of-20-asNeededCodeableConcept.md) | CAVE: This MedicationRequest is for validation purposes and does NOT represent a valid dosageInstruction. It only checks for unsupported Fields |
| [Valid: only text](MedicationRequest-Warning-Dosage-W-DosageStructuredOrFreeTextWarning-01-of-01.md) | Valid example - purely text dosage; allowed but structured dosage preferred. |
| [Warnung: Viererschema im Freitext](MedicationRequest-Warning-Dosage-W-DosageWarnungViererschemaInText-01-of-01.md) | Freitext enthält ein Viererschema (1-0-1-0); soll strukturiert modelliert werden. |
| [Warnung: Viererschema in Dosage.text](MedicationRequest-Warning-Dosage-Viererschema-Text-01.md) | Beispiel, das ein Viererschema (1-1-1-1) in Dosage.text enthält, um die Warn-Invariante auszulösen. |

