# MedicationStatement Dosage Example - Interval - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MedicationStatement Dosage Example - Interval**

## Example MedicationStatement: MedicationStatement Dosage Example - Interval

Profile: [Medication Statement dgMP](StructureDefinition-MedicationStatementDgMP.md)

**status**: Active

**medication**: Test Medication

**subject**: Patient

> **dosage****timing**: Once per 3 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MS-Dosage-Interval",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationStatementDgMP"
    ]
  },
  "status" : "active",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 3,
          "periodUnit" : "d"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
