# Two interval Dosages same time - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Two interval Dosages same time**

## Example MedicationRequest: Two interval Dosages same time

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**status**: Active

**intent**: Order

**medication**: Ibuprofen 400mg

**subject**: Patient

> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |


> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Invalid-multiple-08-of-10-C-TimingOnlyOneTimeOfDay",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Ibuprofen 400mg"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
