# Example-MR-Dosage-UnitTr-1000 - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Example-MR-Dosage-UnitTr-1000**

## Example MedicationRequest: Example-MR-Dosage-UnitTr-1000

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**status**: Active

**intent**: Order

**medication**: Iberogast

**subject**: Patient

> **dosageInstruction****timing**: Morning, Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 20 Tropfen(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code6 = '6') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Example-MR-DosageTr-1000",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Iberogast"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "when" : ["MORN"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 20,
            "unit" : "Tropfen",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "6"
          }
        }
      ]
    }
  ]
}

```
