# Example-MR-Dosage-tod-unsorted - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **Example-MR-Dosage-tod-unsorted**

## Example MedicationRequest: Example-MR-Dosage-tod-unsorted

Profile: [Medication Request dgMP](StructureDefinition-MedicationRequestDgMP.md)

**status**: Active

**intent**: Order

**medication**: Ibuprofen 400mg

**subject**: Patient

> **dosageInstruction****timing**: 2 per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: KBV_CS_SFHIR_BMP_DOSIEREINHEIT code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "Example-MR-Dosage-tod-unsorted",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationRequestDgMP"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "text" : "Ibuprofen 400mg"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 2,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["15:00:00", "08:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "https://fhir.kbv.de/CodeSystem/KBV_CS_SFHIR_BMP_DOSIEREINHEIT",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
