# MedicationDispense Dosage Example - Interval and Time - Medication IG DE v1.0.3

* [**Table of Contents**](toc.md)
* [**FHIR Summary**](artifacts.md)
* **MedicationDispense Dosage Example - Interval and Time**

## Example MedicationDispense: MedicationDispense Dosage Example - Interval and Time

Profile: [Medication Dispense dgMP](StructureDefinition-MedicationDispenseDgMP.md)

**status**: Completed

**medication**: Test Medication

**subject**: Patient

> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 Stück(Details: UCUM code1 = '1') |


> **dosageInstruction****timing**: Once per 2 days

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 Stück(Details: UCUM code1 = '1') |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "MD-Dosage-Interval-Time",
  "meta" : {
    "profile" : [
      "http://ig.fhir.de/igs/medication/StructureDefinition/MedicationDispenseDgMP"
    ]
  },
  "status" : "completed",
  "medicationCodeableConcept" : {
    "text" : "Test Medication"
  },
  "subject" : {
    "display" : "Patient"
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["09:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 2,
          "periodUnit" : "d",
          "timeOfDay" : ["21:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "Stück",
            "system" : "http://unitsofmeasure.org",
            "code" : "1"
          }
        }
      ]
    }
  ]
}

```
