/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.emoji.UGraphicWithScale;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.ColorUtils;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColorSimple;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.openiconic.SvgPath;

public class SvgNanoParser
implements Sprite {
    private final List<String> data = new ArrayList<String>();
    private int minGray = 999;
    private int maxGray = -1;
    private final String svgStart;
    private final boolean keepColors;

    private String extractData(String name, String s) {
        Pattern p = Pattern.compile(name + "=\"([^\"]+)\"");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private String extractDataStyle(String name, String s) {
        Pattern p = Pattern.compile(Pattern.quote(name) + ":([^;\"]+)");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public SvgNanoParser(String svg, boolean keepColors) {
        this(Collections.singletonList(svg), keepColors);
    }

    public SvgNanoParser(List<String> svg, boolean keepColors) {
        this.svgStart = svg.get(0);
        this.keepColors = keepColors;
        for (String singleLine : svg) {
            Pattern p = Pattern.compile("(\\<text .*?\\</text\\>)|(\\<(svg|path|g|circle|ellipse)[^<>]*\\>)|(\\</[^<>]*\\>)");
            Matcher m = p.matcher(singleLine);
            while (m.find()) {
                String s = m.group(0);
                if (s.startsWith("<path") || s.startsWith("<g ") || s.startsWith("<g>") || s.startsWith("</g>") || s.startsWith("<circle ") || s.startsWith("<ellipse ") || s.startsWith("<text ")) {
                    this.data.add(s);
                    continue;
                }
                if (s.startsWith("<svg") || s.startsWith("</svg")) continue;
                System.err.println("???=" + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawU(UGraphic ug, double scale, HColor colorForMonochrome) {
        UGraphicWithScale ugs = new UGraphicWithScale(ug, scale);
        SvgNanoParser svgNanoParser = this;
        synchronized (svgNanoParser) {
            if (colorForMonochrome != null && this.maxGray == -1) {
                this.computeMinMaxGray();
            }
        }
        ArrayList<UGraphicWithScale> stack = new ArrayList<UGraphicWithScale>();
        ArrayDeque<String> stackG = new ArrayDeque<String>();
        for (String s : this.data) {
            if (s.startsWith("<path ")) {
                this.drawPath(ugs, s, colorForMonochrome);
                continue;
            }
            if (s.startsWith("</g>")) {
                ugs = (UGraphicWithScale)stack.remove(0);
                stackG.removeFirst();
                continue;
            }
            if (s.startsWith("<g>")) {
                stack.add(0, ugs);
                stackG.addFirst(s);
                continue;
            }
            if (s.startsWith("<g ")) {
                stack.add(0, ugs);
                stackG.addFirst(s);
                ugs = this.applyFill(ugs, s, colorForMonochrome);
                ugs = this.applyTransform(ugs, s);
                continue;
            }
            if (s.startsWith("<circle ")) {
                this.drawCircle(ugs, s, colorForMonochrome);
                continue;
            }
            if (s.startsWith("<ellipse ")) {
                this.drawEllipse(ugs, s, colorForMonochrome);
                continue;
            }
            if (s.startsWith("<text ")) {
                this.drawText(ugs, s, colorForMonochrome, stackG);
                continue;
            }
            System.err.println("**?=" + s);
        }
    }

    private void computeMinMaxGray() {
        for (String s : this.data) {
            HColor color;
            if (!s.contains("<path ") && !s.contains("<g ") && !s.contains("<circle ") && !s.contains("<ellipse ") || (color = this.justExtractColor(s)) == null) continue;
            int gray = this.getGray(color);
            this.minGray = Math.min(this.minGray, gray);
            this.maxGray = Math.max(this.maxGray, gray);
        }
    }

    private int getGray(HColor col) {
        Color tmp = ColorUtils.getGrayScaleColor(col.toColor(ColorMapper.MONOCHROME));
        return tmp.getGreen();
    }

    private UGraphicWithScale applyFill(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        String fillString = this.getTextFontColor(s, null);
        if (fillString == null) {
            return ugs;
        }
        if (fillString.equals("none")) {
            String strokeString = this.extractData("stroke", s);
            if (strokeString == null) {
                return ugs;
            }
            ugs = ugs.apply(HColors.none().bg());
            HColor stroke = this.getTrueColor(strokeString, colorForMonochrome);
            ugs = ugs.apply(stroke);
            String strokeWidth = this.extractData("stroke-width", s);
            if (strokeWidth != null) {
                double scale = ugs.getScale();
                ugs = ugs.apply(UStroke.withThickness(scale * Double.parseDouble(strokeWidth)));
            }
        } else {
            HColor fill = this.getTrueColor(fillString, colorForMonochrome);
            ugs = ugs.apply(fill).apply(fill.bg());
        }
        return ugs;
    }

    private HColor justExtractColor(String s) {
        String fillString = this.getTextFontColor(s, null);
        if (fillString == null) {
            return null;
        }
        if (fillString.equals("none")) {
            String strokeString = this.extractData("stroke", s);
            if (strokeString == null) {
                return null;
            }
            HColor stroke = this.getTrueColor(strokeString, null);
            return stroke;
        }
        HColor fill = this.getTrueColor(fillString, null);
        return fill;
    }

    private HColor getTrueColor(String code, HColor colorForMonochrome) {
        HColorSimple result = (HColorSimple)HColorSet.instance().getColorOrWhite(code);
        if (colorForMonochrome == null) {
            return result;
        }
        HColorSimple color = (HColorSimple)colorForMonochrome;
        if (color.isGray()) {
            return result.asMonochrome();
        }
        return result.asMonochrome(color, this.minGray, this.maxGray);
    }

    private void drawCircle(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extractData("cx", s)) * scalex;
        double cy = Double.parseDouble(this.extractData("cy", s)) * scaley;
        double rx = Double.parseDouble(this.extractData("r", s)) * scalex;
        double ry = Double.parseDouble(this.extractData("r", s)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(UEllipse.build(rx * 2.0, ry * 2.0));
    }

    private void drawEllipse(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        boolean debug = false;
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        double cx = Double.parseDouble(this.extractData("cx", s));
        double cy = Double.parseDouble(this.extractData("cy", s));
        double rx = Double.parseDouble(this.extractData("rx", s));
        double ry = Double.parseDouble(this.extractData("ry", s));
        UPath path = UPath.none();
        path.moveTo(0.0, ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, rx, 0.0);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, 2.0 * rx, ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, rx, 2.0 * ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, 0.0, ry);
        path.closePath();
        path = path.translate(cx - rx, cy - ry);
        path = path.affine(ugs.getAffineTransform(), ugs.getAngle(), ugs.getScale());
        ugs.draw(path);
    }

    private void drawText(UGraphicWithScale ugs, String s, HColor colorForMonochrome, Deque<String> stackG) {
        double x = Double.parseDouble(this.extractData("x", s));
        double y = Double.parseDouble(this.extractData("y", s));
        String fontColor = this.getTextFontColor(s, stackG);
        int fontSize = this.getTextFontSize(s);
        Pattern p = Pattern.compile("\\<text[^<>]*\\>(.*?)\\</text\\>");
        Matcher m = p.matcher(s);
        if (m.find()) {
            String text = m.group(1);
            HColor color = HColorSet.instance().getColorOrWhite(fontColor);
            String fontFamily = this.getTextFontFamily(s, stackG);
            if (fontFamily == null) {
                fontFamily = "SansSerif";
            }
            UFont font = UFont.build(fontFamily, 0, fontSize);
            FontConfiguration fc = FontConfiguration.create(font, color, color, null);
            UText utext = UText.build(text, fc);
            UGraphic ug = ugs.getUg();
            ug = ug.apply(new UTranslate(x, y));
            ug.draw(utext);
        }
    }

    private String getTextFontFamily(String s, Deque<String> stackG) {
        String style;
        String family = this.extractData("font-family", s);
        if (family == null && (style = this.extractData("style", s)) != null) {
            family = this.extractDataStyle("font-family", style);
        }
        if (family == null && stackG != null) {
            for (String g : stackG) {
                family = this.getTextFontFamily(g, null);
                if (family == null) continue;
                return family;
            }
        }
        return family;
    }

    private String getTextFontColor(String s, Deque<String> stackG) {
        String style;
        String color = this.extractData("fill", s);
        if (color == null && (style = this.extractData("style", s)) != null) {
            color = this.extractDataStyle("fill", style);
        }
        if (color == null && stackG != null) {
            for (String g : stackG) {
                color = this.getTextFontColor(g, null);
                if (color == null) continue;
                return color;
            }
        }
        return color;
    }

    private int getTextFontSize(String s) {
        String style;
        String fontSize = this.extractData("font-size", s);
        if (fontSize == null && (style = this.extractData("style", s)) != null) {
            fontSize = this.extractDataStyle("font-size", style);
        }
        if (fontSize == null) {
            return 14;
        }
        if (fontSize.matches("^\\d+p[tx]$")) {
            return Integer.parseInt(fontSize.replaceAll("[a-z]", ""));
        }
        return Integer.parseInt(fontSize);
    }

    private void drawPath(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        s = s.replace("id=\"", "ID=\"");
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        int x1 = s.indexOf("d=\"");
        int x2 = s.indexOf(34, x1 + 3);
        String tmp = s.substring(x1 + 3, x2);
        SvgPath svgPath = new SvgPath(tmp, UTranslate.none());
        svgPath.drawMe(ugs.getUg(), ugs.getAffineTransform());
    }

    private UGraphicWithScale applyTransform(UGraphicWithScale ugs, String s) {
        String transform = this.extractData("transform", s);
        if (transform == null) {
            return ugs;
        }
        if (transform.contains("rotate(")) {
            return this.applyRotate(ugs, transform);
        }
        if (transform.contains("matrix(")) {
            return this.applyMatrix(ugs, transform);
        }
        double[] scale = this.getScale(transform);
        UTranslate translate = this.getTranslate(transform);
        ugs = ugs.applyTranslate(translate.getDx(), translate.getDy());
        return ugs.applyScale(scale[0], scale[1]);
    }

    private UGraphicWithScale applyMatrix(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("matrix\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double v1 = Double.parseDouble(m3.group(1));
            double v2 = Double.parseDouble(m3.group(2));
            double v3 = Double.parseDouble(m3.group(3));
            double v4 = Double.parseDouble(m3.group(4));
            double v5 = Double.parseDouble(m3.group(5));
            double v6 = Double.parseDouble(m3.group(6));
            ugs = ugs.applyMatrix(v1, v2, v3, v4, v5, v6);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UGraphicWithScale applyRotate(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("rotate\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double angle = Double.parseDouble(m3.group(1));
            double x = Double.parseDouble(m3.group(2));
            double y = Double.parseDouble(m3.group(3));
            ugs = ugs.applyRotate(angle, x, y);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UTranslate getTranslate(String transform) {
        double x = 0.0;
        double y = 0.0;
        Pattern p3 = Pattern.compile("translate\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            x = Double.parseDouble(m3.group(1));
            y = Double.parseDouble(m3.group(2));
        } else {
            Pattern p4 = Pattern.compile("translate\\(([-.0-9]+)\\)");
            Matcher m4 = p4.matcher(transform);
            if (m4.find()) {
                x = Double.parseDouble(m4.group(1));
                y = Double.parseDouble(m4.group(1));
            }
        }
        return new UTranslate(x, y);
    }

    private double[] getScale(String transform) {
        double[] scale = new double[]{1.0, 1.0};
        Pattern p1 = Pattern.compile("scale\\(([-.0-9]+)\\)");
        Matcher m1 = p1.matcher(transform);
        if (m1.find()) {
            scale[0] = Double.parseDouble(m1.group(1));
            scale[1] = scale[0];
        } else {
            Pattern p2 = Pattern.compile("scale\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
            Matcher m2 = p2.matcher(transform);
            if (m2.find()) {
                scale[0] = Double.parseDouble(m2.group(1));
                scale[1] = Double.parseDouble(m2.group(2));
            }
        }
        return scale;
    }

    @Override
    public TextBlock asTextBlock(final HColor color, final double scale) {
        UImageSvg data = new UImageSvg(this.svgStart, scale);
        final double width = data.getWidth();
        final double height = data.getHeight();
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                SvgNanoParser.this.drawU(ug, scale, SvgNanoParser.this.keepColors ? null : color);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }
}

