/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.elk;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.elk.MyElkCluster;
import net.sourceforge.plantuml.elk.proxy.graph.ElkBendPoint;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdge;
import net.sourceforge.plantuml.elk.proxy.graph.ElkEdgeSection;
import net.sourceforge.plantuml.elk.proxy.graph.ElkLabel;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import net.sourceforge.plantuml.klimt.geom.MagneticBorderNone;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.skin.LineParam;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactoryExtends;

public class MyElkEdge
implements UDrawable {
    private final Link link;
    private final ElkEdge edge;
    private final CucaDiagram diagram;
    private final TextBlock centerLabel;
    private final TextBlock headLabel;
    private final TextBlock tailLabel;
    private final SName styleName;
    private final Map<Entity, MyElkCluster> elkClusters;
    private final Map<Entity, IEntityImage> nodeImages;
    private final double magicY2;
    private final UTranslate translate;

    public MyElkEdge(CucaDiagram diagram, SName styleName, Link link, ElkEdge edge, TextBlock centerLabel, TextBlock tailLabel, TextBlock headLabel, double magicY2, Map<Entity, MyElkCluster> elkClusters, UTranslate translate, Map<Entity, IEntityImage> nodeImages) {
        this.link = link;
        this.edge = edge;
        this.translate = translate;
        this.nodeImages = nodeImages;
        this.diagram = diagram;
        this.centerLabel = centerLabel;
        this.tailLabel = tailLabel;
        this.headLabel = headLabel;
        this.styleName = styleName;
        this.magicY2 = magicY2;
        this.elkClusters = elkClusters;
    }

    private Style getStyle() {
        StyleSignature result = StyleSignatureBasic.of(SName.root, SName.element, this.diagram.getUmlDiagramType().getStyleName(), SName.arrow).withTOBECHANGED(this.link.getStereotype());
        return result.getMergedStyle(this.diagram.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public void drawU(UGraphic ug) {
        UTranslate force;
        double y;
        double x;
        if (this.link.isHidden()) {
            return;
        }
        UGraphic ugOrig = ug = ug.apply(this.translate);
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style styleLine = this.getStyle();
        HColor color = styleLine.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        if (this.link.getColors() != null) {
            HColor newColor = this.link.getColors().getColor(ColorType.ARROW, ColorType.LINE);
            if (newColor != null) {
                color = newColor;
            }
        } else if (this.link.getSpecificColor() != null) {
            color = this.link.getSpecificColor();
        }
        LinkType linkType = this.link.getType();
        UStroke suggestedStroke = styleLine.getStroke();
        UStroke defaultThickness = this.diagram.getSkinParam().getThickness(LineParam.arrow, null);
        UStroke stroke = suggestedStroke == null || !linkType.getStyle().isNormal() ? linkType.getStroke3(defaultThickness) : linkType.getStroke3(suggestedStroke);
        if (this.link.getColors() != null && this.link.getColors().getSpecificLineStroke() != null) {
            stroke = this.link.getColors().getSpecificLineStroke();
        }
        MyElkCluster elkCluster1 = this.elkClusters.get(this.link.getEntity1());
        MyElkCluster elkCluster2 = this.elkClusters.get(this.link.getEntity2());
        IEntityImage elkNode1 = this.nodeImages.get(this.link.getEntity1());
        IEntityImage elkNode2 = this.nodeImages.get(this.link.getEntity2());
        MagneticBorder magneticBorder1 = new MagneticBorderNone();
        MagneticBorder magneticBorder2 = new MagneticBorderNone();
        if (elkNode1 != null) {
            magneticBorder1 = elkNode1.getMagneticBorder();
        } else if (elkCluster1 != null) {
            magneticBorder1 = elkCluster1.getMagneticBorder(ug.getStringBounder());
        }
        if (elkNode2 != null) {
            magneticBorder2 = elkNode2.getMagneticBorder();
        }
        if (elkCluster2 != null) {
            magneticBorder2 = elkCluster2.getMagneticBorder(ug.getStringBounder());
        }
        ug = ug.apply(stroke).apply(color);
        List<ElkEdgeSection> sections = this.edge.getSections();
        if (sections.size() == 0) {
            System.err.println("Strange: no section?");
            System.err.println("Maybe a 'Long hierarchical edge' " + this.edge.isHierarchical());
            return;
        }
        this.drawSections(ug, sections, magneticBorder1, magneticBorder2);
        UDrawable extremityFactory1 = this.getDecors(this.link.getType().getDecor1(), 1.5707963267948966, HColors.WHITE);
        UDrawable extremityFactory2 = this.getDecors(this.link.getType().getDecor2(), -1.5707963267948966, HColors.WHITE);
        if (extremityFactory1 != null) {
            x = sections.get(0).getEndX();
            y = sections.get(0).getEndY();
            force = magneticBorder2.getForceAt(ug.getStringBounder(), new XPoint2D(x, y));
            extremityFactory1.drawU(ug.apply(stroke.onlyThickness()).apply(new UTranslate(x, y).compose(force)));
        }
        if (extremityFactory2 != null) {
            x = sections.get(0).getStartX();
            y = sections.get(0).getStartY();
            force = magneticBorder1.getForceAt(ug.getStringBounder(), new XPoint2D(x, y));
            extremityFactory2.drawU(ug.apply(stroke.onlyThickness()).apply(new UTranslate(x, y).compose(force)));
        }
        this.drawLabels(ugOrig);
    }

    private UDrawable getDecors(LinkDecor decors, double angle, HColor backColor) {
        if (decors == LinkDecor.EXTENDS) {
            return new ExtremityFactoryExtends(backColor).createUDrawable(new XPoint2D(0.0, 0.0), angle, null);
        }
        ExtremityFactory extremityFactory = decors.getExtremityFactoryLegacy(backColor);
        if (extremityFactory == null) {
            return null;
        }
        return extremityFactory.createUDrawable(new XPoint2D(0.0, 0.0), angle, null);
    }

    private void drawLabels(UGraphic ug) {
        for (ElkLabel label : this.edge.getLabels()) {
            TextBlock labelLink;
            double x = label.getX();
            double y = label.getY();
            String type = label.getText();
            if ("X".equals(type)) {
                labelLink = this.centerLabel;
            } else if ("1".equals(type)) {
                labelLink = this.tailLabel;
            } else {
                if (!"2".equals(type)) continue;
                labelLink = this.headLabel;
            }
            labelLink.drawU(ug.apply(new UTranslate(x, y)));
        }
    }

    private void drawSections(UGraphic ug, Collection<ElkEdgeSection> sections, MagneticBorder magneticBorder1, MagneticBorder magneticBorder2) {
        for (ElkEdgeSection section : sections) {
            Collection<ElkBendPoint> points = section.getBendPoints();
            double x1 = section.getStartX();
            double y1 = section.getStartY();
            XPoint2D tmpStart = new XPoint2D(x1, y1);
            UTranslate force1 = magneticBorder1.getForceAt(ug.getStringBounder(), this.translate.getTranslated(tmpStart));
            XPoint2D start = force1.getTranslated(tmpStart);
            x1 = start.x;
            y1 = start.y;
            for (ElkBendPoint pt : points) {
                this.drawLine(ug, x1, y1, pt.getX(), pt.getY());
                x1 = pt.getX();
                y1 = pt.getY();
            }
            XPoint2D tmpEnd = new XPoint2D(section.getEndX(), section.getEndY() + this.magicY2);
            UTranslate force2 = magneticBorder2.getForceAt(ug.getStringBounder(), this.translate.getTranslated(tmpEnd));
            XPoint2D end = force2.getTranslated(tmpEnd);
            this.drawLine(ug, x1, y1, end.x, end.y);
        }
    }

    private void drawLine(UGraphic ug, double x1, double y1, double x2, double y2) {
        ULine line = new ULine(x2 - x1, y2 - y1);
        ug.apply(new UTranslate(x1, y1)).draw(line);
    }
}

