# Profiles and Extensions - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles have been defined for this implementation guide.

#### CommunicationRequest

* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md) 
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)
 

#### Consent

* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)

#### Coverage

* [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)

#### DocumentReference

* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)

#### ServiceRequest

* [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) 
* [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)
* [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)
 

#### Task

* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md) 
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
 

#### Other Profiles Used

In addition to the profiles defined in this implementation guide, the following profiles defined elsewhere are used by AU eRequesting. These profiles are a data type profile for a **Must Support** element in an AU eRequesting profile or are the target of a **Must Support** reference element in an AU eRequesting profile:

* [AU Local Order Identifier](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-au-localorderidentifier.html)
* [AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html)
* [Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html)
* [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html)
* [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html)
* [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html)

**Figure 1: AU eRequesting Profiles** 

### Extensions

All [extensions](http://hl7.org/fhir/R4/extensibility.html) used in this guide are defined as part of this guide, in the FHIR Extensions Pack or [AU Base](https://build.fhir.org/ig/hl7au/au-fhir-base/profiles-and-extensions.html#extensions).

The following extensions are marked with **Must Support** in this implementation guide, or are marked with **Must Support** in a profile referenced by AU eRequesting:

* [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [Australian Indigenous Status](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-indigenous-status.html) in [AU Core Patient](http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient)
* [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) in [AU Core Patient](http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient)
* [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) in [AU Core Patient](http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient)
* [Patient Sex Parameter For Clinical Use](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse.html) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [Request status reason](http://hl7.org/fhir/StructureDefinition/request-statusReason) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)

