# Examples - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **Examples**

## Examples

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The following examples are published with this guide and all are available as a downloadable as zip file [here](downloads.md#examples).

These example instances show what data produced and consumed by systems conforming with this implementation guide might look like. Every effort has been made to ensure that the examples are correct and useful, but they are not a normative part of the specification nor are they fully representative of real world examples.

In addition to the examples defined in this implementation, synthetic (realistic but not real) test data for developers and testers that conforms to HL7 Australia FHIR implementation guides is maintained in the [HL7 AU FHIR Test Data](https://github.com/hl7au/au-fhir-test-data) repository.

### CommunicationRequest

* [CommunicationRequest - Copy To GP](CommunicationRequest-communicationrequest-copyto-gp.md)

* [CommunicationRequest - Patient communication - do not perform](CommunicationRequest-communicationrequest-donotperform.md)

* [CommunicationRequest - Patient instructions from the diagnostic provider](CommunicationRequest-communicationrequest-patient-instruction.md)

* [CommunicationRequest - Urgent results communication to provider](CommunicationRequest-communicationrequest-urgent-results-to-provider.md)

### Consent

* [Consent - My Health Record Consent Withdrawal](Consent-mhr-consent-withdrawal.md)

### Coverage

* [Coverage - Concession](Coverage-coverage-concession.md)

* [Coverage - DVA](Coverage-coverage-dva.md)

### DocumentReference

* [DocumentReference - Clinical Context](DocumentReference-documentreference-clinical-context.md)

### Encounter

* [Encounter - Consultation](Encounter-gp-consultation.md)

* [Encounter - OBGYN Outpatient Clinic](Encounter-obsgynaeclinic.md)

### Location

* [Location - Barney View Private Hospital](Location-barney-view-private-hospital.md)

### Observation

* [Observation - Pregnancy Status](Observation-observation-pregnancy-status.md)

### Organization

* [Organization - Barney View Private Hospital](Organization-barney-view-private-hospital.md)

* [Organization - Elimbah Medical Center](Organization-elimbah-medical-center.md)

* [Organization - Kioma Pathology Laboratory](Organization-kioma-pathology.md)

* [Organization - Mount Charlton Radiology](Organization-mount-charlton-radiology.md)

### Patient

* [Patient - Remedios Belger](Patient-belger-remedios.md)

* [Patient - Ronny Lawrence Irvine](Patient-irvine-ronny-lawrence.md)

* [Patient - Fred Roberts](Patient-roberts-fred.md)

### Practitioner

* [Practitioner - Aimee Herbert](Practitioner-herbert-aimee.md)

* [Practitioner - Sallie Losch](Practitioner-losch-sallie.md)

* [Practitioner - Kimberlee McLaughlin](Practitioner-mclaughlin-kimberlee.md)

* [Practitioner - Dr. Jarred Guthridge](Practitioner-practitioner-guthridge-jarred.md)

### PractitionerRole

* [PractitionerRole - Radiologist](PractitionerRole-diagnostic-mclaughlin-kimberlee.md)

* [PractitionerRole - General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

* [PractitionerRole - Obstetrician and gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

* [PractitionerRole - Pathologist](PractitionerRole-pathologist-herbert-aimee.md)

### ServiceRequest

* [ServiceRequest - Blood Group and Antibodies panel](ServiceRequest-order-bg-abs.md)

* [ServiceRequest - Full Blood Count](ServiceRequest-order-fbc-1.md)

* [ServiceRequest - Fasting Blood Glucose](ServiceRequest-order-glu-1.md)

* [ServiceRequest - Iron studies](ServiceRequest-order-ironstudies.md)

* [ServiceRequest - Obstetric Ultrasound (Second Trimester)](ServiceRequest-order-obsus-1.md)

* [ServiceRequest - Urine Microscopy, Culture and Sensitivity](ServiceRequest-order-urinemcs-1.md)

* [ServiceRequest - X-ray](ServiceRequest-order-xray-1.md)

### Task

* [Task - Communication Request - Urgent results communication to provider](Task-task-communicationrequest-urgent-results-to-provider.md)

* [Task - Imaging Fulfilment Task](Task-taskfulfilment-imaging-1.md)

* [Task - Pathology Fulfilment Task](Task-taskfulfilment-pathology-1.md)

* [Task - Imaging Task Group](Task-taskgroup-imaging-1.md)

* [Task - Pathology Task Group](Task-taskgroup-pathology-1.md)

