# Artefacts Summary - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* **Artefacts Summary**

## Artefacts Summary

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md) | The AU eRequesting Filler is a system that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. |
| [AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md) | A system that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. |
| [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md) | The AU eRequesting Placer is a system that is responsible for creating diagnostic requests. |
| [AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | The eRequesting Server is a system that accepts diagnostic service requests and makes diagnostic service requests accessible. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md) | This CapabilityStatement describes the basic rules for the[AU eRequesting Filler actor](ActorDefinition-au-erequesting-actor-filler.md)that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Filler actor are defined in this CapabilityStatement. |
| [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md) | This CapabilityStatement describes the basic rules for the[AU eRequesting Patient actor](ActorDefinition-au-erequesting-actor-patient.md)that is the digital interface that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU eRequesting Patient actor are defined in this CapabilityStatement. |
| [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) | This CapabilityStatement describes the basic rules for the[AU eRequesting Placer actor](ActorDefinition-au-erequesting-actor-placer.md)that is responsible for creating diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Placer actor are defined in this CapabilityStatement. |
| [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md) | This CapabilityStatement describes the basic rules for the[AU eRequesting Server actor](ActorDefinition-au-erequesting-actor-server.md)that is is a system that accepts diagnostic service requests and makes diagnostic service requests accessible. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Server actor are defined in this CapabilityStatement. |

### Structures: Abstract Profiles 

These are profiles on resources or data types that describe patterns used by other profiles, but cannot be instantiated directly. I.e. instances can conform to profiles **based** on these abstract profiles, but do not declare conformance to the abstract profiles themselves.

| | |
| :--- | :--- |
| [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md) | This profile sets minimum expectations for CommunicationRequest resources that are used to record, search, and fetch information about a communication request to be performed. It is based on the[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html)resource and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. |
| [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic requests for a patient. It is based on the[AU Base ServiceRequest](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-au-servicerequest.html)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the ServiceRequest resource when conforming to this profile. |
| [AU eRequesting Task](StructureDefinition-au-erequesting-task.md) | This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a task to be performed. It is based on the[Task](https://www.hl7.org/fhir/R4/task.html)resource and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the Task resource when conforming to this profile. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | This profile sets minimum expectations for representing clinical context using a DocumentReference resource to record, search, and fetch clinical context narrative information that provides an overview of the individual’s current clinical situation associated with a requested service. Clinical context is intended to describe the broader clinical background or circumstances relating to the request, supporting the service provider in making informed decisions about service delivery. It is based on the[DocumentReference](https://hl7.org/fhir/R4/documentreference.html)resource and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the DocumentReference when conforming to this profile. |
| [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md) | This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for a report to be copied to a clinician or patient as an additional recipient. A copy-to clinician is distinct from a request for urgent communication to a provider, as the priority may not be urgent. It is based on the[AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. |
| [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md) | This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a patient. It is based on the[AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. |
| [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a clinical provider for the purpose of providing urgent results. This communication is not a substitute for the formal diagnostic report, but is intended to provide timely notification of a result, usually by phone. It is based on the[AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. |
| [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | This profile sets minimum expectations for a Coverage resource that is used to record, search, and fetch information about insurance or medical plan or a payment agreement for a patient. It is based on the[AU Base Coverage](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-au-coverage.html)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the Coverage when conforming to this profile. |
| [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic imaging requests for a patient. It is based on the[AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the ServiceRequest resource when conforming to this profile. |
| [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md) | This profile sets minimum expectations for a Consent resource to record, search, and fetch a My Health Record (MHR) consent withdrawal. It represents a patient’s withdrawal of consent to upload to MHR in accordance with paragraph 45(d) of the[My Health Records Act 2012](https://www.legislation.gov.au/C2012A00063). It is based on the[Consent](https://hl7.org/fhir/R4/consent.html)resource and identifies the additional mandatory core elements, extensions, vocabularies and value sets that**SHALL**be present in the Consent when conforming to this profile. |
| [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about pathology requests for a patient. It is based on the[AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the ServiceRequest resource when conforming to this profile. |
| [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md) | This profile sets minimum expectations for a Task resource that is used to track the fulfilment of a communication request. For example, whether fulfilment of the communication request was attempted, successful, or failed. It is based on the[AU eRequesting Task](StructureDefinition-au-erequesting-task.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the Task resource when conforming to this profile. |
| [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md) | This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a diagnostic request task to be fulfilled. It is based on the[AU eRequesting Task](StructureDefinition-au-erequesting-task.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the Task resource when conforming to this profile. |
| [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a group of tasks that are part of the same fulfilment group. It is based on the[AU eRequesting Task](StructureDefinition-au-erequesting-task.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the Task resource when conforming to this profile. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md) | This extension applies to the ServiceRequest resource and is used to represent the integer assigned to an individual test or service in a ServiceRequest that corresponds with the sequential position in which a test or service appears on a paper request form.Sorting by display sequence enables more efficient reconciliation of paper and digital request data at the point of service provision. |
| [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md) | This extension applies to the ServiceRequest resource and is used to represent whether fasting is a recommended precondition for the diagnostic request. It conveys the requester’s recommendation regarding fasting at the time of ordering, not the actual fasting status of the patient. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU eRequesting CommunicationRequest Patient Category](ValueSet-au-erequesting-communicationrequest-patientcategory.md) | Category values for patient communication used in the Australian eRequesting context. |
| [AU eRequesting CommunicationRequest Patient Medium](ValueSet-au-erequesting-communicationrequest-patientmedium.md) | Medium values for patient communication used in the Australian eRequesting context. |
| [AU eRequesting CommunicationRequest Reason](ValueSet-au-erequesting-communicationrequest-reason.md) | Reason codes for a communication request used in the Australian eRequesting context. |
| [AU eRequesting Coverage Type and Self-Pay Codes](ValueSet-au-erequesting-coverage-type.md) | Coverage type and self-pay codes typically used in the Australian eRequesting context. |
| [AU eRequesting Fulfilment Task Tags](ValueSet-au-erequesting-fulfilment-task-tags.md) | Task tag values for labelling and differentiating fulfilment of tasks used in an Australian eRequesting context. |
| [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md) | ServiceRequest status values used in the Australian eRequesting context. |
| [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md) | Task business status values used in the Australian eRequesting context. |
| [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) | Task status values used in the Australian eRequesting context. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [CommunicationRequest - Copy To GP](CommunicationRequest-communicationrequest-copyto-gp.md) | Shows an example communication request for the**AU eRequesting CommunicationRequest CopyTo**profile, requesting a GP as a report copy-to recipient. Patient: Remedios Belger. |
| [CommunicationRequest - Patient communication - do not perform](CommunicationRequest-communicationrequest-donotperform.md) | Shows an example communication request for the**AU eRequesting CommunicationRequest Patient**profile, requesting no email communication from the diagnostic provider regarding reminders or instructions to the patient. Patient: Remedios Belger. |
| [CommunicationRequest - Patient instructions from the diagnostic provider](CommunicationRequest-communicationrequest-patient-instruction.md) | Shows an example communication request for the**AU eRequesting CommunicationRequest Patient**profile, capturing the patient’s communication preferences for receiving SMS instructions for a test from the diagnostic provider. Patient: Remedios Belger. |
| [CommunicationRequest - Urgent results communication to provider](CommunicationRequest-communicationrequest-urgent-results-to-provider.md) | Shows an example communication request for the**AU eRequesting CommunicationRequest Urgent Provider**profile, requesting a provider receive communication about urgent results. Patient: Fred Roberts. |
| [Consent - My Health Record Consent Withdrawal](Consent-mhr-consent-withdrawal.md) | Shows an example of consent to upload X-ray results to the My Health Record withdrawn by patient for the**AU eRequesting MHR Consent Withdrawal**profile. Patient: Fred Roberts. |
| [Coverage - Concession](Coverage-coverage-concession.md) | Shows an example of coverage for the**AU eRequesting Coverage**profile, demonstrating a self funded beneficiary type with a concession. Beneficiary: Fred Roberts. |
| [Coverage - DVA](Coverage-coverage-dva.md) | Shows an example of coverage for the**AU eRequesting Coverage**profile, demonstrating the Department of Veterans’ Affairs coverage type. Beneficiary: Ronny Lawrence Irvine. |
| [DocumentReference - Clinical Context](DocumentReference-documentreference-clinical-context.md) | Shows an example DocumentReference for the**AU eRequesting Clinical Context DocumentReference**profile, associated with a diagnostic request. Patient: Remedios Belger. |
| [Encounter - Consultation](Encounter-gp-consultation.md) | Shows an example of an encounter for the**AU Core Encounter**profile, representing a general practice consultation. Patient: Fred Roberts. |
| [Encounter - OBGYN Outpatient Clinic](Encounter-obsgynaeclinic.md) | Shows an example for the**AU Core Encounter**profile, representing a hospital outpatient obstetrics clinic visit. Patient: Remedios Belger. |
| [Location - Barney View Private Hospital](Location-barney-view-private-hospital.md) | Shows an example of a location, Barney View Private Hospital, for the**AU Core Location**profile. |
| [Observation - Pregnancy Status](Observation-observation-pregnancy-status.md) | Shows an example of the**Pregnancy - Status (IPS)**profile, with a result of Pregnant. Patient: Remedios Belger. |
| [Organization - Barney View Private Hospital](Organization-barney-view-private-hospital.md) | Shows an example of an organisation, Barney View Private Hospital, for the**AU Core Organization**profile, with HPI-O and ABN, type as hospital, contact information and physical address. |
| [Organization - Elimbah Medical Center](Organization-elimbah-medical-center.md) | Shows an example of an organisation, Elimbah Medical Center, for the**AU Core Organization**profile, with HPI-O and contact details. |
| [Organization - Kioma Pathology Laboratory](Organization-kioma-pathology.md) | Shows an example of an organisation, Kioma Pathology Laboratory, for the**AU Core Organization**profile, with HPI-O, type as a pathology laboratory, contact information and physical address. |
| [Organization - Mount Charlton Radiology](Organization-mount-charlton-radiology.md) | Shows an example of an organisation, Mount Charlton Radiology, for the**AU Core Organization**profile, with HPI-O, type as a radiology practice, contact information and physical address. |
| [Patient - Fred Roberts](Patient-roberts-fred.md) | Shows an example of a patient, Fred Roberts, for the**AU Core Patient**profile, with an IHI, contact details, gender, birth date, address, and Indigenous status. |
| [Patient - Remedios Belger](Patient-belger-remedios.md) | Shows an example of a patient, Remedios Belger, for the**AU Core Patient**profile with IHI, medicare number, contact details, gender, birth date, address, and Indigenous status. |
| [Patient - Ronny Lawrence Irvine](Patient-irvine-ronny-lawrence.md) | Shows an example of a patient, Ronny Lawrence Irvine, for the**AU Core Patient**profile, with an IHI, Medicare and DVA identifiers. |
| [Practitioner - Aimee Herbert](Practitioner-herbert-aimee.md) | Shows an example of a practitioner, Aimee Herbert, for the**AU Core Practitioner**profile, including HPI-I and name information. |
| [Practitioner - Dr. Jarred Guthridge](Practitioner-practitioner-guthridge-jarred.md) | Shows an example of a practitioner, Jarred Guthridge, for the**AU Core Practitioner**profile, including HPI-I and name information. |
| [Practitioner - Kimberlee McLaughlin](Practitioner-mclaughlin-kimberlee.md) | Shows an example of a practitioner, Kimberlee McLaughlin, for the**AU Core Practitioner**profile, including HPI-I and name information. |
| [Practitioner - Sallie Losch](Practitioner-losch-sallie.md) | Shows an example of a practitioner, Sallie Losch, for the**AU Core Practitioner**profile, including HPI-I, name and APHRA information. |
| [PractitionerRole - General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md) | Shows an example of a General Practitioner role for the**AU Core PractitionerRole**profile, using a Medicare Provider Number as the role identifier, and references to the associated Practitioner and Organization. |
| [PractitionerRole - Obstetrician and gynaecologist](PractitionerRole-obstetrician-losch-sallie.md) | Shows an example of an obstetrician and gynaecologist, Sallie Losch, for the**AU Core PractitionerRole**profile, including Medicare Provider Number, associated organisation, role, and contact details. |
| [PractitionerRole - Pathologist](PractitionerRole-pathologist-herbert-aimee.md) | Shows an example of a Pathologist role for the**AU Core PractitionerRole**profile, including Medicare Provider Number, role, telecom and references to the associated Practitioner and Organization. |
| [PractitionerRole - Radiologist](PractitionerRole-diagnostic-mclaughlin-kimberlee.md) | Shows an example of a Radiologist role for the**AU Core PractitionerRole**profile, including Medicare Provider Number, role, telecom and references to the associated Practitioner and Organization. |
| [ServiceRequest - Blood Group and Antibodies panel](ServiceRequest-order-bg-abs.md) | Shows an example of a request for a blood group and antibodies panel for the**AU eRequesting Pathology Request**profile. Patient: Remedios Belger. |
| [ServiceRequest - Fasting Blood Glucose](ServiceRequest-order-glu-1.md) | Shows an example of a request for a Fasting Blood Glucose test for the**AU eRequesting Pathology Request**profile. Patient: Remedios Belger. |
| [ServiceRequest - Full Blood Count](ServiceRequest-order-fbc-1.md) | Shows an example of a request for a Full Blood Count (FBC) for the**AU eRequesting Pathology Request**profile. Patient: Fred Roberts. |
| [ServiceRequest - Iron studies](ServiceRequest-order-ironstudies.md) | Shows an example of a request for an Iron Studies group or panel of blood tests for the**AU eRequesting Pathology Request**profile. The request contains a context-specific sex parameter for clinical use and a status reason. Patient: Remedios Belger. |
| [ServiceRequest - Obstetric Ultrasound (Second Trimester)](ServiceRequest-order-obsus-1.md) | Shows an example of a request for an obstetric ultrasound in the second trimester for the**AU eRequesting Imaging Request**profile. Patient: Remedios Belger. |
| [ServiceRequest - Urine Microscopy, Culture and Sensitivity](ServiceRequest-order-urinemcs-1.md) | Shows an example of a request for a Urine Microscopy, Culture and Sensitivity test for the**AU eRequesting Pathology Request**profile. The request contains the precondition of nonfasting and pregnancy status supporting information. Patient: Remedios Belger. |
| [ServiceRequest - X-ray](ServiceRequest-order-xray-1.md) | Shows an example of a request for a chest X-ray for the**AU eRequesting Imaging Request**profile. Patient: Fred Roberts. |
| [Task - Communication Request - Urgent results communication to provider](Task-task-communicationrequest-urgent-results-to-provider.md) | Shows an example of a task for fulfilment of a communication request for the**AU eRequesting Task Communication Request**profile. Patient: Fred Roberts. |
| [Task - Imaging Fulfilment Task](Task-taskfulfilment-imaging-1.md) | Shows an example of a task for fulfilment of an Imaging Request for the**AU eRequesting Task Diagnostic Request**profile. Patient: Fred Roberts. |
| [Task - Imaging Task Group](Task-taskgroup-imaging-1.md) | Shows an example of a group of tasks that are part of the same fulfilment group for an Imaging Request for the**AU eRequesting Task Group**profile. Patient: Fred Roberts. |
| [Task - Pathology Fulfilment Task](Task-taskfulfilment-pathology-1.md) | Shows an example of a task for fulfilment of a Pathology Request for the**AU eRequesting Task Diagnostic Request**profile. Patient: Fred Roberts. |
| [Task - Pathology Task Group](Task-taskgroup-pathology-1.md) | Shows an example of a group of tasks that are part of the same fulfilment group for a Pathology Request for the**AU eRequesting Task Group**profile. Patient: Fred Roberts. |

