# ServiceRequest - X-ray - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - X-ray**

## Example ServiceRequest: ServiceRequest - X-ray

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)

**AU eRequesting Display Sequence**: 1

**identifier**: Placer Identifier/EMC4542244-5624-01

**requisition**: Placer Group Number/EMC4542244-5624

**status**: Active

**intent**: Order

**category**: Imaging

**code**: Chest X-Ray

**subject**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); serviceType = General practice service; period = 2024-05-11 10:15:00+1000 --> 2024-05-11 10:30:00+1000](Encounter-gp-consultation.md)

**authoredOn**: 2024-05-11

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**insurance**: [Coverage: status = active; type = Concession; relationship = Self; period = 2023-01-01 --> (ongoing)](Coverage-coverage-concession.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-xray-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 1
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC4542244-5624-01",
      "assigner" : {
        "display" : "Elimbah Medical Center"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC4542244-5624",
    "assigner" : {
      "display" : "Elimbah Medical Center"
    }
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "363679005",
          "display" : "Imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "399208008",
        "display" : "Plain chest X-ray"
      }
    ],
    "text" : "Chest X-Ray"
  },
  "subject" : {
    "reference" : "Patient/roberts-fred"
  },
  "encounter" : {
    "reference" : "Encounter/gp-consultation"
  },
  "authoredOn" : "2024-05-11",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "insurance" : [
    {
      "reference" : "Coverage/coverage-concession"
    }
  ]
}

```
