# ServiceRequest - Urine Microscopy, Culture and Sensitivity - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - Urine Microscopy, Culture and Sensitivity**

## Example ServiceRequest: ServiceRequest - Urine Microscopy, Culture and Sensitivity

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)

**AU eRequesting Display Sequence**: 3

**AU eRequesting Fasting Precondition**: Nonfasting

**identifier**: Placer Identifier/EMC1552642-1110-03

**requisition**: Placer Group Number/EMC1552642-1110

**status**: Active

**intent**: Order

**category**: Laboratory procedure

**priority**: Urgent

**code**: Urine MCS

**quantity**: 1 1(Details: UCUM code1 = '1')

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2025-02-21 07:50:00+1000 --> 2025-02-21 08:20:00+1000](Encounter-obsgynaeclinic.md)

**occurrence**: 2025-02-21 08:10:00+1000

**authoredOn**: 2025-02-21

**requester**: [PractitionerRole Obstetrician and Gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

**supportingInfo**: 

* [Clinical context](DocumentReference-documentreference-clinical-context.md)
* [Pregnancy status](Observation-observation-pregnancy-status.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-urinemcs-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 3
    },
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-fastingprecondition",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "440565004",
            "display" : "Nonfasting"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC1552642-1110-03",
      "assigner" : {
        "display" : "Elimbah Medical Center"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1110",
    "assigner" : {
      "display" : "Elimbah Medical Center"
    }
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "401324008",
        "display" : "Urine microscopy, culture and sensitivities"
      }
    ],
    "text" : "Urine MCS"
  },
  "quantityQuantity" : {
    "value" : 1,
    "system" : "http://unitsofmeasure.org",
    "code" : "1"
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "encounter" : {
    "reference" : "Encounter/obsgynaeclinic"
  },
  "occurrenceDateTime" : "2025-02-21T08:10:00+10:00",
  "authoredOn" : "2025-02-21",
  "requester" : {
    "reference" : "PractitionerRole/obstetrician-losch-sallie"
  },
  "supportingInfo" : [
    {
      "reference" : "DocumentReference/documentreference-clinical-context",
      "display" : "Clinical context"
    },
    {
      "reference" : "Observation/observation-pregnancy-status",
      "display" : "Pregnancy status"
    }
  ]
}

```
