# ServiceRequest - Obstetric Ultrasound (Second Trimester) - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - Obstetric Ultrasound (Second Trimester)**

## Example ServiceRequest: ServiceRequest - Obstetric Ultrasound (Second Trimester)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)

**AU eRequesting Display Sequence**: 1

**identifier**: Placer Identifier/EMC1552642-1111-01

**requisition**: Placer Group Number/EMC1552642-1111

**status**: Active

**intent**: Order

**category**: Imaging

**code**: 2nd Trimester US

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2025-02-21 07:50:00+1000 --> 2025-02-21 08:20:00+1000](Encounter-obsgynaeclinic.md)

**occurrence**: 2025-05-08 --> 2025-06-11

**authoredOn**: 2025-02-21

**requester**: [PractitionerRole Obstetrician and Gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

**supportingInfo**: [Pregnancy status](Observation-observation-pregnancy-status.md)

**note**: 

> 

18-22 week Morphology scan. Pt advised the scan is ideally done around 20 weeks gestation.




## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-obsus-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 1
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC1552642-1111-01",
      "assigner" : {
        "display" : "Elimbah Medical Center"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1111",
    "assigner" : {
      "display" : "Elimbah Medical Center"
    }
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "363679005",
          "display" : "Imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "446208007",
        "display" : "Ultrasonography in second trimester"
      }
    ],
    "text" : "2nd Trimester US"
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "encounter" : {
    "reference" : "Encounter/obsgynaeclinic"
  },
  "occurrencePeriod" : {
    "start" : "2025-05-08",
    "end" : "2025-06-11"
  },
  "authoredOn" : "2025-02-21",
  "requester" : {
    "reference" : "PractitionerRole/obstetrician-losch-sallie"
  },
  "supportingInfo" : [
    {
      "reference" : "Observation/observation-pregnancy-status",
      "display" : "Pregnancy status"
    }
  ],
  "note" : [
    {
      "text" : "18-22 week Morphology scan. Pt advised the scan is ideally done around 20 weeks gestation."
    }
  ]
}

```
