# PractitionerRole - Radiologist - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - Radiologist**

## Example PractitionerRole: PractitionerRole - Radiologist

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html)

**identifier**: Medicare Provider Number/2448501H

**practitioner**: [Practitioner Kimberlee McLaughlin](Practitioner-mclaughlin-kimberlee.md)

**organization**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)

**code**: Radiologist

**telecom**: ph: (07) 701 07257, [kimberlee.mclaughlin@mouncharltonradiology.example.net](mailto:kimberlee.mclaughlin@mouncharltonradiology.example.net)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "diagnostic-mclaughlin-kimberlee",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN",
            "display" : "Medicare Provider Number"
          }
        ],
        "text" : "Medicare Provider Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2448501H"
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/mclaughlin-kimberlee"
  },
  "organization" : {
    "reference" : "Organization/mount-charlton-radiology"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "66862007",
          "display" : "Radiologist"
        }
      ],
      "text" : "Radiologist"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(07) 701 07257"
    },
    {
      "system" : "email",
      "value" : "kimberlee.mclaughlin@mouncharltonradiology.example.net"
    }
  ]
}

```
