# Patient - Ronny Lawrence Irvine - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Ronny Lawrence Irvine**

## Example Patient: Patient - Ronny Lawrence Irvine

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html)

Ronny LAWRENCE IRVINE (official) Male, DoB: 1953-07-19 ( IHI: Austalian Healthcare Identifier - Individual#8003608833648421)

-------

| | |
| :--- | :--- |
| Other Ids: | * Medicare Number/29545407011
* DVA Number/QX827261
 |
| Contact Detail | * ph: 0270105046(Home)
* ph: 0491572665(Mobile)
* ph: 0270100361(Work)
* 180 Hermann Rd Belmore River NSW 2440 AU 
 |
| Individual Pronouns: | * value: they/them/their/theirs/themselves
 |
| Person Recorded Sex Or Gender: | * type: Biological sex at birth
* value: Male
 |
| [Australian Indigenous Status](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1 2: Torres Strait Islander but not Aboriginal origin |
| Individual Gender Identity: | * value: Identifies as gender nonbinary
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "irvine-ronny-lawrence",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "2",
        "display" : "Torres Strait Islander but not Aboriginal origin"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-genderIdentity",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "33791000087105",
                "display" : "Identifies as gender nonbinary"
              }
            ]
          }
        }
      ]
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA29520-6",
                "display" : "they/them/their/theirs/themselves"
              }
            ]
          }
        }
      ]
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender",
      "extension" : [
        {
          "url" : "type",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "1515311000168102",
                "display" : "Biological sex at birth"
              }
            ]
          }
        },
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "248153007",
                "display" : "Male"
              }
            ]
          }
        }
      ]
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608833648421"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MC"
          }
        ],
        "text" : "Medicare Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-number",
      "value" : "29545407011"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "DVAU",
            "display" : "DVA Number"
          }
        ],
        "text" : "DVA Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/dva",
      "value" : "QX827261"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "IRVINE",
      "given" : ["Ronny", "LAWRENCE"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0270105046",
      "use" : "home"
    },
    {
      "system" : "phone",
      "value" : "0491572665",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0270100361",
      "use" : "work"
    }
  ],
  "gender" : "male",
  "birthDate" : "1953-07-19",
  "address" : [
    {
      "line" : ["180 Hermann Rd"],
      "city" : "Belmore River",
      "state" : "NSW",
      "postalCode" : "2440",
      "country" : "AU"
    }
  ]
}

```
