# Organization - Elimbah Medical Center - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Elimbah Medical Center**

## Example Organization: Organization - Elimbah Medical Center

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html)

**identifier**: HPI-O/8003629900040359

**type**: Medical Center

**name**: Elimbah Medical Center

**telecom**: [info@elimbahmedicalcentre.example.com.au](mailto:info@elimbahmedicalcentre.example.com.au), ph: (07)555 03997(Work)

**address**: 199 Copper Esp Elimbah QLD 4516 AU 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "elimbah-medical-center",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003629900040359"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "288565001",
          "display" : "Medical centre"
        }
      ],
      "text" : "Medical Center"
    }
  ],
  "name" : "Elimbah Medical Center",
  "telecom" : [
    {
      "system" : "email",
      "value" : "info@elimbahmedicalcentre.example.com.au",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(07)555 03997",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["199 Copper Esp"],
      "city" : "Elimbah",
      "state" : "QLD",
      "postalCode" : "4516",
      "country" : "AU"
    }
  ]
}

```
