# Observation - Pregnancy Status - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Pregnancy Status**

## Example Observation: Observation - Pregnancy Status

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html)

**status**: Final

**code**: Pregnancy status

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**effective**: 2025-02-21

**performer**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**value**: Pregnant



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-pregnancy-status",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
    ]
  },
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "82810-3"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "effectiveDateTime" : "2025-02-21",
  "performer" : [
    {
      "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "77386006"
      }
    ]
  }
}

```
