# Location - Barney View Private Hospital - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Location - Barney View Private Hospital**

## Example Location: Location - Barney View Private Hospital

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html)

**name**: Barney View Private Hospital

**address**: 195 Maple Cct Barney View QLD 4287 

**physicalType**: Site

**managingOrganization**: [Organization Barney View Private Hospital](Organization-barney-view-private-hospital.md)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "barney-view-private-hospital",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
    ]
  },
  "name" : "Barney View Private Hospital",
  "address" : {
    "line" : ["195 Maple Cct"],
    "city" : "Barney View",
    "state" : "QLD",
    "postalCode" : "4287"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "si",
        "display" : "Site"
      }
    ]
  },
  "managingOrganization" : {
    "reference" : "Organization/barney-view-private-hospital"
  }
}

```
