# Consent - My Health Record Consent Withdrawal - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Consent - My Health Record Consent Withdrawal**

## Example Consent: Consent - My Health Record Consent Withdrawal

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)

**status**: Active

**scope**: Patient Privacy

**category**: information disclosure

**patient**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**dateTime**: 2024-05-11

**performer**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**organization**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)

### Policies

| | | |
| :--- | :--- | :--- |
| - | **Authority** | **Uri** |
| * | [https://www.health.gov.au](https://www.health.gov.au) | [https://www.legislation.gov.au/C2012A00063](https://www.legislation.gov.au/C2012A00063) |

**policyRule**: Opt in

> **provision****type**: Opt Out**action**:Disclose**class**:[ResourceType DiagnosticReport](http://hl7.org/fhir/R4/codesystem-resource-types.html#resource-types-DiagnosticReport): DiagnosticReport

### Data

| | | |
| :--- | :--- | :--- |
| - | **Meaning** | **Reference** |
| * | Dependents | [ServiceRequest Plain chest X-ray](ServiceRequest-order-xray-1.md) |




## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "mhr-consent-withdrawal",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-mhrconsentwithdrawal"
    ]
  },
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "version" : "1",
        "code" : "patient-privacy",
        "display" : "Privacy Consent"
      }
    ],
    "text" : "Patient Privacy"
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "version" : "1",
          "code" : "IDSCL",
          "display" : "information disclosure"
        }
      ],
      "text" : "information disclosure"
    }
  ],
  "patient" : {
    "reference" : "Patient/roberts-fred"
  },
  "dateTime" : "2024-05-11",
  "performer" : [
    {
      "reference" : "Patient/roberts-fred"
    }
  ],
  "organization" : [
    {
      "reference" : "Organization/mount-charlton-radiology"
    }
  ],
  "policy" : [
    {
      "authority" : "https://www.health.gov.au",
      "uri" : "https://www.legislation.gov.au/C2012A00063"
    }
  ],
  "policyRule" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "version" : "1",
        "code" : "OPTIN"
      }
    ],
    "text" : "Opt in"
  },
  "provision" : {
    "type" : "deny",
    "action" : [
      {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/consentaction",
            "code" : "disclose",
            "display" : "Disclose"
          }
        ]
      }
    ],
    "class" : [
      {
        "system" : "http://hl7.org/fhir/resource-types",
        "code" : "DiagnosticReport"
      }
    ],
    "data" : [
      {
        "meaning" : "dependents",
        "reference" : {
          "reference" : "ServiceRequest/order-xray-1"
        }
      }
    ]
  }
}

```
