# Use Cases - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **Use Cases**

## Use Cases

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

The use cases described below set out the target state for AU eRequesting, with an initial focus on pathology and medical imaging requests in community-based care provision. They may be delivered over multiple releases of the Implementation Guide and will be expanded and refined over time as the Implementation Guide evolves.

Community input is vital for updating AU eRequesting use cases. We encourage our audience to submit questions and feedback on the implementation guide by clicking on the Propose a change link in the footer of every page.

Column attribute descriptions are as follows:

* **ID**: A unique identifier for each use case.
* **Description**: Narrative of the use case, outlining the scenario and the sequence of actions involved.
* **Actor(s)**: Represents the actors involved in the use case.
* **Data Group(s)**: Relevant AU eRequest Diagnostic Imaging (AUeReqDI) or the Australian Clinical Diagnostic Imaging (AUCDI) data group.

See [AU eRequesting Data for Interoperability Mappings](auereqdi.md) for the relationship between the AUeReqDI or AUCDI data groups, elements, and AU eRequesting profiles.

### Diagnostic Imaging Use Cases

| | | | |
| :--- | :--- | :--- | :--- |
| D01 | **Request for diagnostic imaging (generic data collection requirements)**A requesting clinician requires diagnostic imaging for a patient, following a consultation about an affected body part. The request contains information such as: Patient demographics (including sex and gender), Targeted body part, Type of imaging required, Reason for requesting imaging, relevant clinical history, any precautions about the patient’s other conditions such as device implants/allergies/medicines/related pathology results, destination(s) where the results need to be sent back to (including Copy To/Carbon Copy/copy to practitioners, as well as the original requestor), and information to support billing. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md) | * Service request
* Medical imaging request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| D02 | **Request for diagnostic imaging (Assigned request)**A requesting clinician decides that an MRI head scan is indicated for a patient. The clinician and patient agree upon a local diagnostic imaging service provider and the clinician submits the eRequest for the scan directly to that provider. The patient is not required to present an eRequest token to the provider when they make a booking or attend the test. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md) | * Service request
* Medical imaging request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| D03 | **Request for diagnostic examination (Unassigned request)**A requesting clinician requires a chest X-Ray for a patient, following a consultation about pain in their torso. The clinician creates the eRequest, then generates a token and gives this to the patient. The patient researches local diagnostic imaging service providers and makes a booking with one of them. When the patient makes a booking or attends the appointment, they present the token to the service provider who uses it to download the eRequest information into their booking system. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)[AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md) | * Service request
* Medical imaging request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| D04 | **Request for diagnostic examination (Reassigned request)**A requesting clinician requires a CT Brain scan (with contrast) for a patient, following a consultation about neurological symptoms. The clinician and patient agree upon a local diagnostic imaging service provider and the clinician submits the eRequest for the scan to that provider. Before the patient is due to attend the provider, the patient changes their mind and elects to have the test performed by a different provider. The patient makes a booking with the new provider and when they attend the appointment they present a token to the service provider who uses it to download the eRequest information into their booking system. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)[AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
* Medical imaging request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |

### Pathology Use Cases

| | | | |
| :--- | :--- | :--- | :--- |
| P10 | **Request for a pathology test (generic data collection requirements)**A requesting clinician requires a pathology test for a patient, following a consultation. The request contains information such as: Patient demographics (including sex and gender), Specimen type, Type of test required, Reason for requesting, any precautions about the patient’s other conditions such as device implants/allergies/medicines/related pathology results, destination(s) where the results need to be sent back to (including Copy To/Carbon Copy/copy to practitioners, as well as the original requestor), and information to support billing. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md) | * Service request
* Pathology test request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| P02 | **Request for a pathology test (Assigned request)**A requesting clinician requires a Liver Function Test to be performed on a patient to assist with diagnosing a condition. The clinician creates the request and after discussing service providers with the patient, sends it directly to a pathology service that the clinician and patient agree upon. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md) | * Service request
* Pathology test request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| P01 | **Request for a pathology test (Unassigned request)**A requesting clinician requires a Full Blood Count test to be performed on a patient to assist with diagnosing a condition. The clinician creates the eRequest, then generates a token and gives this to the patient. The patient researches local pathology service providers and selects one to perform the test. The patient presents the token to the service provider who uses it to download the eRequest information into their Collection system or Laboratory Information System (LIS). | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)[AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
* Pathology test request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| P03 | **Request for a pathology test (Reassigned request)**A requesting clinician requires a Thyroid Stimulating Hormone (TSH) test to be performed on a patient. The clinician creates the request and after discussing service providers with the patient, sends it directly to a pathology service that the clinician and patient agree upon. After leaving the clinician's office, the patient changes their mind and elects to have the test performed by a different provider. The patient proceeds directly to the new provider and presents a token for the request, which the provider uses to download the eRequest information into their testing management system. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)[AU eRequesting Patient](ActorDefinition-au-erequesting-actor-patient.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
* Pathology test request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |
| P09 | **Rule 3 INR Test**A clinician requests an ongoing International Normalized Ratio (INR) test specifying a "Rule 3 Exemption" for a patient undergoing anticoagulant therapy. The requester requires 6 INR tests to be performed over the next 6 months. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md) | * Service request
* Pathology test request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |

### General Use Cases

| | | | |
| :--- | :--- | :--- | :--- |
| G01 | **Tracking fulfilment of a Service Request**A GP checks the status of a requested test for a patient, e.g. Accepted, Cancelled, Pending, Collected, Preliminary, Completed, etc. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
 |
| G02 | **Cancelling an eRequest (requestor)**An eRequest is revoked/cancelled by the requesting health care professional because the requested service is no longer required. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
 |
| G03 | **Cancelling an eRequest (provider)**An eRequest is revoked/cancelled by the service provider because they are no longer able to provide the requested service for the patient. This cancellation has occurred before the provider has started the service (e.g. before the patient has attended the provider), hence it is not considered a non-fulfilment of the service. | [AU eRequesting Filler](ActorDefinition-au-erequesting-actor-filler.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
 |
| G07 | **Specification of results to be copied to another clinician**A hospital clinician requests diagnostic imaging for a patient after they have been discharged from the hospital, as a follow-up test. The results are requested to be sent to the hospital clinician and the patient's GP. | [AU eRequesting Placer](ActorDefinition-au-erequesting-actor-placer.md)[AU eRequesting Server](ActorDefinition-au-erequesting-actor-server.md) | * Service request
* Implanted medical device summary
* Adverse reaction risk summary
* Problem/Diagnosis summary
* Sex and gender summary
 |

