# Sex and Gender - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Sex and Gender**

## Sex and Gender

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page addresses how sex and gender related concepts can be structured in FHIR and conformant to AU eRequesting.

AU eRequesting places **Must Support** on some concepts and inherits sex and gender related elements localised in AU Base, which has considered the logical data element models provided by [HL7 International’s Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1 specification (Gender Harmony IG)](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/). AU Core profiles referenced in AU eRequesting place **Must Support** on some concepts and inherit sex and gender elements localised in AU Base.

The table below provides an overview of the sex and gender concepts that are included in AU eRequesting by definition, or by reference to AU Core or AU Base.

**Legend:**

![](green_checkmark.png) **Supported**: The sex or gender related concept is marked as **Must Support**.

![](orange_checkmark.png) **Localised**: The sex or gender related concept is localised for use in an Australian context but is not marked as **Must Support**.

![](blue_checkmark.png) **Not Localised**: The sex or gender related concept is relevant and not yet localised for use in an Australian context.

![](minus_symbol.png) **Not Applicable**: This sex or gender related concept is not applicable for use with this resource type.

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AU eRequestingDiagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU eRequestingImaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU eRequestingPathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU CorePatient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU CorePractitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html) | ![](blue_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |
| [AU CoreRelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html) | ![](blue_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |

### Administrative Gender (Patient.gender)

By reference to AU Core Patient, AU eRequesting supports the exchange of Administrative Gender, i.e. the basic `Patient.gender` property, as a **Must Support** element in [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html). As per AU Base, the `Patient.gender` value **SHALL** be regarded as a Recorded Sex or Gender. AU Core adopts without change, the implementation guidance defined in the [Administrative Gender (Patient.gender)](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#administrative-gender-patientgender) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

### Name to Use (NtU)

By reference to AU Core Patient, AU eRequesting supports the exchange of the Name to Use data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)), and `name.use` is a **Must Support** element in [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) and [AU Core RelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html). It is important to note that, `name.period` is not a **Must Support** element. AU Core adopts without change, the implementation guidance defined in the [Name to Use (NtU)](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#name-to-use-ntu) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

### Pronouns​

By reference to AU Core Patient, AU eRequesting supports the exchange of the Pronouns data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Individual Pronouns](https://build.fhir.org/ig/HL7/fhir-extensions//StructureDefinition-individual-pronouns.html) extension is a **Must Support** element in [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html), with the value element of the extension constrained to be [Australian Pronouns](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/australian-pronouns-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU Core adopts without change, the implementation guidance defined in the [Pronouns](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#pronouns) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

### Gender Identity (GI)

By reference to AU Core Patient, AU eRequesting supports the exchange of the Gender Identity data element (as defined in the [HL7 Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Individual Gender Identity](https://build.fhir.org/ig/HL7/fhir-extensions//StructureDefinition-individual-genderIdentity.html) extension is a **Must Support** element in [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html), with the value element of the extension constrained to be [Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU Core adopts without change, the implementation guidance defined in the [Gender Identity](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#gender-identity-gi) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

### Recorded Sex or Gender

In AU Core profiles referenced by AU eRequesting, Recorded Sex or Gender is not **Must Support**. See the implementation guidance defined in the [Recorded Sex or Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#recorded-sex-or-gender) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page for more information.

### Sex Assigned at Birth

In AU Core, Sex Assigned at Birth is profiled as [AU Core Sex Assigned At Birth](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-rsg-sexassignedab.html). While elements within AU Core Sex Assigned at Birth are **Must Support**, usage of the profile is not **Must Support** in [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) which is referenced by AU eRequesting. That profile provides an implementation of the guidance in the [Sex Assigned at Birth](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#sex-assigned-at-birth) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

### Sex Parameter for Clinical Use (SPCU)

 The guidance on this page is dependent on the availability of the `intendedClinicalUse` element, added to the SPCU extension in the September 2025 Ballot of the HL7 International FHIR Extensions Pack. 

AU eRequesting supports the exchange of the Sex Parameter for Clinical Use (SPCU) data element (as defined by the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Patient Sex Parameter for Clinical Use](https://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-sexParameterForClinicalUse.html) extension is a **Must Support** element in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md), [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) and [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) and a maximum of one SPCU value is allowed.

The inclusion of an SPCU value indicates that the requester is explicitly providing a sex parameter intended for use in fulfilment of the requested diagnostic service. When it is present in an [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) or [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md), it conveys the AU eRequesting Placer’s intended SPCU for the diagnostic request and can be relied upon by AU eRequesting Filler to support the requested service.

It is recommended that the clinical context for the SPCU value is also provided (e.g. Use female reference intervals when interpreting results). Clinical context clarifies the intended use of the SPCU, supports accurate interpretation by AU eRequesting Fillers, and reduces ambiguity where the patient’s other sex and gender attributes may differ. Clinical context can be included in either the [`comment`](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse-definitions.html#Extension.extension:comment) or [`intendedClinicalUse`](https://build.fhir.org/ig/HL7/fhir-extensions/StructureDefinition-patient-sexParameterForClinicalUse-definitions.html#Extension.extension:intendedClinicalUse) element.

See the implementation guidance defined in the [Sex Parameter for Clinical Use (SPCU)](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html#sex-parameter-for-clinical-use-spcu) section of the AU Base [Sex and Gender](https://build.fhir.org/ig/hl7au/au-fhir-base/sexgender.html) page.

