# Home - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq | *Version*:1.0.0-ci-build | |
| *IG Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingImplementationGuide |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

### Introduction

AU eRequesting is provided to support the use of HL7® FHIR®© for diagnostic requesting in an Australian context. It sets the minimum expectations on FHIR resources to support conformance and implementation in systems.

AU eRequesting defines the data model and RESTful API interactions that set minimum expectations for placing and accessing electronic requests.

The focus of AU eRequesting Release 1 (R1) is to support pathology and medical imaging requests in community-based care, while also considering future applications beyond this scope.

### Project Background

This implementation guide is under development through the AU eRequesting project as part of the [Sparked AU FHIR Accelerator](https://sparked.csiro.au). The Sparked AU FHIR Accelerator is a collaborative community of government, technology vendors, provider organisations, peak bodies, practitioners, and domain experts, working together to accelerate the creation and use of national FHIR standards for health information exchange and workflow.

The Sparked AU FHIR Accelerator includes:

* AU eRequesting Data for Interoperability - clinician focussed data requirements
* AU eRequesting FHIR Implementation Guide - HL7 Australia technical data access and exchange specification

The [Australian eRequesting Data for Interoperability (AUeReqDI)](https://sparked.csiro.au/index.php/products-resources/auereqdi/) is focused on an agreement of the minimum data required to support standardised eRequesting within the Australian health context, and forms a common language foundation that allows systems to exchange semantically accurate data for eRequests. AUeReqDI outputs form a set of data requirements to be considered and referred to as part of the development and definition of AU eRequesting.

### Scope of AU eRequesting Release 1

The scope of AU eRequesting Release 1 is the support of pathology and medical imaging requests in community-based care provision.

#### In-Scope Scenarios

The following diagnostic request scenarios are in scope for Release 1:

* Electronic requests for pathology and medical imaging services, with support for patient choice via assigned or unassigned requests: 
* From community-based clinicians to: 
* Private diagnostic service providers
* Public hospital-based diagnostic service providers
* Interstate diagnostic service providers
 
* From hospital outpatient services to community-based diagnostic providers
 
* Request fulfilment tracking: 
* Systems can monitor the status and progression of requests throughout the fulfilment process
 

See AU eRequesting [Use Cases](use-cases.md) for complete use case descriptions.

#### Out of Scope

The following diagnostic request scenarios are outside the scope of Release 1:

* Handling of diagnostic reports
* Inpatient and inter-hospital workflows
* Sendaway workflows where specimens are referred to another laboratory
* Specimen collection processes
* Appointment scheduling and booking

As Release 1 focuses on defining a foundational FHIR data model and RESTful API interactions, several technical aspects are intentionally out of scope. This approach supports alignment and adoption by emerging diagnostic requesting solutions, while maintaining flexibility to respond to evolving national policy directions and infrastructure considerations in future releases or downstream implementation guides.

The following technical aspects were not considered priority for the scope of Release 1:

* Authentication, authorisation, and auditing
* Barcode or QR code definition and format
* Provider discovery and federated resource location patterns
* Claiming of diagnostic requests by fillers
* Supporting information for ServiceRequests not yet defined, for example, Adverse Reaction Risk Summary or Problem/Diagnosis Summary

### Dependencies








### AU eRequesting FHIR RESTful Interactions

AU eRequesting defines four system actors involved in the exchange of diagnostic requests: the AU eRequesting Placer, Filler, Patient and Server actors. The [Actors and Capabilities](capability-statements.md) page provides a summary of these actors and includes links to their definitions and CapabilityStatements. Each capability statement outlines the RESTful interactions supported by that actor, including `create`, `update`, `read` and `search` operations.

Figure 1 shows typical FHIR RESTful interactions between these AU eRequesting actors:

**Figure 1: Typical FHIR RESTful interactions between AU eRequesting actors** 

### Example AU eRequesting Interaction Flow

Figure 2 shows an example of FHIR interactions between AU eRequesting actors, and demonstrates the use of ServiceRequest and Task to support the placement and tracking of pathology and imaging requests. While the diagram focuses on these coordinating resources, the associated exchange also includes other FHIR resources (e.g. Patient) that provide clinical, administrative and contextual information. The full set of profiles used to support the requests is provided on the [Profiles and Extensions](profiles-and-extensions.md) page.

**Figure 2: Example AU eRequesting interaction flow** 

The steps illustrated in Figure 2 are summarised below:

* The AU eRequesting Placer actor creates ServiceRequest and Task resources on the AU eRequesting Server, along with associated resources that collectively represent the request.
* The AU eRequesting Filler actor searches for available Task resources to fulfil, and retrieves the associated resources that form the request.
* The AU eRequesting Filler actor updates the Task resources to reflect the fulfilment status.
* The AU eRequesting Placer actor queries the AU eRequesting Server to monitor request fulfilment status.
* The AU eRequesting Patient actor queries the AU eRequesting Server to view the details of their own requests.

### How To Read This Guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* [Conformance](conformance.md): This page describes the set of rules to claim conformance to this guide
* [Guidance](guidance.md): These pages list the guidance for this guide. 
* [General Guidance](general-guidance.md): This page provides guidance on using the profiles defined in this guide.
* [AU eRequesting Workflow Guidance](workflow.md): This page provides guidance on managing workflow states in AU eRequesting, where Tasks track the fulfilment of ServiceRequests.
* [Sex and Gender](sex-and-gender.md): This page provides guidance on the representation of sex, gender, and related concepts.
* [AU eRequesting Data for Interoperability Mappings](auereqdi.md): This page maps AUeReqDI data groups and elements to FHIR artefacts in AU eRequesting.
* [Relationships to Other Specifications](relationship.md): This page provides guidance on the relationship between AU eRequesting, AUeReqDI, and other implementation guides.
* [AU Variance Statement](variance.md): This page documents variance from AU Base and AU Core.
* [Future of AU eRequesting](future.md): This page outlines the approach to developing AU eRequesting and yearly update cycle.
 
* [Use Cases](use-cases.md): This page describes the use cases in scope of eRequesting R1.
* [Security and Privacy](security.md): This page documents the AU eRequesting general security and privacy recommendations.
* [FHIR Artefacts](artifacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artefacts Summary](artifacts.md): This page lists the FHIR artefacts defined in this guide.
* [Profiles and Extensions](profiles-and-extensions.md): This page describes the profiles and extensions that are defined in this guide to support electronic requesting. Each profile page includes a narrative description and guidance, formal definition and a “Notes” section which summarises the supported search transactions for each profile. Although the guidance typically focuses on the profiled elements, it may also may focus on un-profiled elements to aid with implementation.
* [Terminology](terminology.md): This page lists the value sets and code systems supported in this guide.
* [Actors and Capabilities](capability-statements.md): This page defines the AU eRequesting actors and their respective CapabilityStatements.
 
* [Examples](examples.md): This page lists all the examples used in this guide.
* [Support](support.md): These pages provide supporting material for implementation of AU eRequesting. 
* [Downloads](downloads.md): This page provides links to downloadable artefacts.
* [License and Legal](license.md): This page outlines the license and legal requirements for material in AU eRequesting.
 
* [Change Log](changes.md): This page documents the changes across versions of this guide.

### Collaboration

This guide is the product of collaborative work undertaken with participants from:

* [Sparked HL7 Australia AU eRequesting Technical Design Group](https://confluence.hl7.org/display/HAFWG/HL7+Australia+-+AU+eRequesting+Technical+Design+Group+Home)
* [HL7 Australia FHIR Working Group](https://confluence.hl7.org/display/HAFWG/HL7+Australia+FHIR+Work+Group+Home)
* Australian FHIR Implementers Community

Primary Editors: Brett Esler, Jaymee Murdoch, Michael Osborne.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.au.ereq",
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingImplementationGuide",
  "title" : "AU eRequesting Implementation Guide",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This implementation guide is provided to support the use of FHIR®© for clinical requesting and ordering in an Australian context. , and defines the minimum set of constraints on the FHIR resources to create the AU eRequesting profiles.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "packageId" : "hl7.fhir.au.ereq",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_au_base",
      "uri" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
      "packageId" : "hl7.fhir.au.base",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_au_core",
      "uri" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core",
      "packageId" : "hl7.fhir.au.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "current"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ranzcr.com/fhir/ValueSet/radiology-referral-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-coverage-type"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-request-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-task-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-fulfilment-task-tags"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-task-businessstatus"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/resource-tag"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/task-business-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0-ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org.au/fhir/ereq/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2024"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ranzcr.com/fhir/ValueSet/radiology-referral-1"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-coverage-type"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-request-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-task-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-fulfilment-task-tags"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-task-businessstatus"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/resource-tag"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.hl7.org.au/CodeSystem/task-business-status"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludexml"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludejson"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludettl"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0-ballot"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "tx"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "generate"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "init"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "CI Build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org.au/fhir/ereq/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-clinicalcontext-documentreference"
        },
        "name" : "AU eRequesting Clinical Context DocumentReference",
        "description" : "This profile sets minimum expectations for representing clinical context using a DocumentReference resource to record, search, and fetch clinical context narrative information that provides an overview of the individual's current clinical situation associated with a requested service. Clinical context is intended to describe the broader clinical background or circumstances relating to the request, supporting the service provider in making informed decisions about service delivery.  It is based on the [DocumentReference](https://hl7.org/fhir/R4/documentreference.html) resource and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the DocumentReference when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-communicationrequest"
        },
        "name" : "AU eRequesting CommunicationRequest",
        "description" : "This profile sets minimum expectations for CommunicationRequest resources that are used to record, search, and fetch information about a communication request to be performed.  It is based on the [CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html) resource and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-communicationrequest-copyto"
        },
        "name" : "AU eRequesting CommunicationRequest CopyTo",
        "description" : "This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for a report to be copied to a clinician or patient as an additional recipient. A copy-to clinician is distinct from a request for urgent communication to a provider, as the priority may not be urgent. It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-communicationrequest-patient"
        },
        "name" : "AU eRequesting CommunicationRequest Patient",
        "description" : "This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a patient. It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-communicationrequest-patientcategory"
        },
        "name" : "AU eRequesting CommunicationRequest Patient Category",
        "description" : "Category values for patient communication used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-communicationrequest-patientmedium"
        },
        "name" : "AU eRequesting CommunicationRequest Patient Medium",
        "description" : "Medium values for patient communication used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-communicationrequest-reason"
        },
        "name" : "AU eRequesting CommunicationRequest Reason",
        "description" : "Reason codes for a communication request used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-communicationrequest-urgentprovider"
        },
        "name" : "AU eRequesting CommunicationRequest Urgent Provider",
        "description" : "This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a clinical provider for the purpose of providing urgent results. This communication is not a substitute for the formal diagnostic report, but is intended to provide timely notification of a result, usually by phone.  It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-coverage"
        },
        "name" : "AU eRequesting Coverage",
        "description" : "This profile sets minimum expectations for a Coverage resource that is used to record, search, and fetch information about insurance or medical plan or a payment agreement for a patient. It is based on the [AU Base Coverage](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-au-coverage.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Coverage when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-coverage-type"
        },
        "name" : "AU eRequesting Coverage Type and Self-Pay Codes",
        "description" : "Coverage type and self-pay codes typically used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-diagnosticrequest"
        },
        "name" : "AU eRequesting Diagnostic Request",
        "description" : "This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic requests for a patient. It is based on the [AU Base ServiceRequest](https://build.fhir.org/ig/hl7au/au-fhir-base/StructureDefinition-au-servicerequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the ServiceRequest resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-displaysequence"
        },
        "name" : "AU eRequesting Display Sequence",
        "description" : "This extension applies to the ServiceRequest resource and is used to represent the integer assigned to an individual test or service in a ServiceRequest that corresponds with the sequential position in which a test or service appears on a paper request form.\n\nSorting by display sequence enables more efficient reconciliation of paper and digital request data at the point of service provision.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-fastingprecondition"
        },
        "name" : "AU eRequesting Fasting Precondition",
        "description" : "This extension applies to the ServiceRequest resource and is used to represent whether fasting is a recommended precondition for the diagnostic request. It conveys the requester's recommendation regarding fasting at the time of ordering, not the actual fasting status of the patient.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-erequesting-actor-filler"
        },
        "name" : "AU eRequesting Filler",
        "description" : "The AU eRequesting Filler is a system that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-erequesting-filler"
        },
        "name" : "AU eRequesting Filler CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Filler actor](ActorDefinition-au-erequesting-actor-filler.html) that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Filler actor are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-fulfilment-task-tags"
        },
        "name" : "AU eRequesting Fulfilment Task Tags",
        "description" : "Task tag values for labelling and differentiating fulfilment of tasks used in an Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-servicerequest-imag"
        },
        "name" : "AU eRequesting Imaging Request",
        "description" : "This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic imaging requests for a patient. It is based on the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the ServiceRequest resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-mhrconsentwithdrawal"
        },
        "name" : "AU eRequesting MHR Consent Withdrawal",
        "description" : "This profile sets minimum expectations for a Consent resource to record, search, and fetch a My Health Record (MHR) consent withdrawal. It represents a patient's withdrawal of consent to upload to MHR in accordance with paragraph 45(d) of the [My Health Records Act 2012](https://www.legislation.gov.au/C2012A00063). It is based on the [Consent](https://hl7.org/fhir/R4/consent.html) resource and identifies the additional mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Consent when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-servicerequest-path"
        },
        "name" : "AU eRequesting Pathology Request",
        "description" : "This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about pathology requests for a patient. It is based on the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the ServiceRequest resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-erequesting-actor-patient"
        },
        "name" : "AU eRequesting Patient",
        "description" : "A system that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-erequesting-patient"
        },
        "name" : "AU eRequesting Patient CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Patient actor](ActorDefinition-au-erequesting-actor-patient.html) that is the digital interface that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU eRequesting Patient actor are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-erequesting-actor-placer"
        },
        "name" : "AU eRequesting Placer",
        "description" : "The AU eRequesting Placer is a system that is responsible for creating diagnostic requests.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-erequesting-placer"
        },
        "name" : "AU eRequesting Placer CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Placer actor](ActorDefinition-au-erequesting-actor-placer.html) that is responsible for creating diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Placer actor are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-request-status"
        },
        "name" : "AU eRequesting RequestStatus",
        "description" : "ServiceRequest status values used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-erequesting-actor-server"
        },
        "name" : "AU eRequesting Server",
        "description" : "The eRequesting Server is a system that accepts diagnostic service requests and makes diagnostic service requests accessible.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-erequesting-server"
        },
        "name" : "AU eRequesting Server CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Server actor](ActorDefinition-au-erequesting-actor-server.html) that is  is a system that accepts diagnostic service requests and makes diagnostic service requests accessible. The complete list of FHIR profiles, RESTful operations, and search parameters supported by the AU eRequesting Server actor are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource:abstract"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-task"
        },
        "name" : "AU eRequesting Task",
        "description" : "This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a task to be performed. It is based on the [Task](https://www.hl7.org/fhir/R4/task.html) resource and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-task-businessstatus"
        },
        "name" : "AU eRequesting Task Business Status",
        "description" : "Task business status values used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-task-communicationrequest"
        },
        "name" : "AU eRequesting Task Communication Request",
        "description" : "This profile sets minimum expectations for a Task resource that is used to track the fulfilment of a communication request. For example, whether fulfilment of the communication request was attempted, successful, or failed. It is based on the [AU eRequesting Task](StructureDefinition-au-erequesting-task.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-task-diagnosticrequest"
        },
        "name" : "AU eRequesting Task Diagnostic Request",
        "description" : "This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a diagnostic request task to be fulfilled. It is based on the [AU eRequesting Task](StructureDefinition-au-erequesting-task.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-erequesting-task-group"
        },
        "name" : "AU eRequesting Task Group",
        "description" : "This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a group of tasks that are part of the same fulfilment group. It is based on the [AU eRequesting Task](StructureDefinition-au-erequesting-task.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/au-erequesting-task-status"
        },
        "name" : "AU eRequesting Task Status",
        "description" : "Task status values used in the Australian eRequesting context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/barney-view-private-hospital"
        },
        "name" : "Location - Barney View Private Hospital",
        "description" : "Shows an example of a location, Barney View Private Hospital, for the *AU Core Location* profile.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/barney-view-private-hospital"
        },
        "name" : "Organization - Barney View Private Hospital",
        "description" : "Shows an example of an organisation, Barney View Private Hospital, for the *AU Core Organization* profile, with HPI-O and ABN, type as hospital, contact information and physical address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/belger-remedios"
        },
        "name" : "Patient - Remedios Belger",
        "description" : "Shows an example of a patient, Remedios Belger, for the *AU Core Patient* profile with IHI, medicare number, contact details, gender, birth date, address, and Indigenous status.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/communicationrequest-copyto-gp"
        },
        "name" : "CommunicationRequest - Copy To GP",
        "description" : "Shows an example communication request for the *AU eRequesting CommunicationRequest CopyTo* profile, requesting a GP as a report copy-to recipient. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/communicationrequest-donotperform"
        },
        "name" : "CommunicationRequest - Patient communication - do not perform",
        "description" : "Shows an example communication request for the *AU eRequesting CommunicationRequest Patient* profile, requesting no email communication from the diagnostic provider regarding reminders or instructions to the patient. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/communicationrequest-patient-instruction"
        },
        "name" : "CommunicationRequest - Patient instructions from the diagnostic provider",
        "description" : "Shows an example communication request for the *AU eRequesting CommunicationRequest Patient* profile, capturing the patient's communication preferences for receiving SMS instructions for a test from the diagnostic provider. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/communicationrequest-urgent-results-to-provider"
        },
        "name" : "CommunicationRequest - Urgent results communication to provider",
        "description" : "Shows an example communication request for the *AU eRequesting CommunicationRequest Urgent Provider* profile, requesting a provider receive communication about urgent results. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-urgentprovider"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/coverage-concession"
        },
        "name" : "Coverage - Concession",
        "description" : "Shows an example of coverage for the *AU eRequesting Coverage* profile, demonstrating a self funded beneficiary type with a concession. Beneficiary: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/coverage-dva"
        },
        "name" : "Coverage - DVA",
        "description" : "Shows an example of coverage for the *AU eRequesting Coverage* profile, demonstrating the Department of Veterans’ Affairs coverage type. Beneficiary: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/diagnostic-mclaughlin-kimberlee"
        },
        "name" : "PractitionerRole - Radiologist",
        "description" : "Shows an example of a Radiologist role for the *AU Core PractitionerRole* profile, including Medicare Provider Number, role, telecom and references to the associated Practitioner and Organization.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/documentreference-clinical-context"
        },
        "name" : "DocumentReference - Clinical Context",
        "description" : "Shows an example DocumentReference for the *AU eRequesting Clinical Context DocumentReference* profile, associated with a diagnostic request. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/elimbah-medical-center"
        },
        "name" : "Organization - Elimbah Medical Center",
        "description" : "Shows an example of an organisation, Elimbah Medical Center, for the *AU Core Organization* profile, with HPI-O and contact details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
        },
        "name" : "PractitionerRole - General practitioner",
        "description" : "Shows an example of a General Practitioner role for the *AU Core PractitionerRole* profile, using a Medicare Provider Number as the role identifier, and references to the associated Practitioner and Organization.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/gp-consultation"
        },
        "name" : "Encounter - Consultation",
        "description" : "Shows an example of an encounter for the *AU Core Encounter* profile, representing a general practice consultation. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/herbert-aimee"
        },
        "name" : "Practitioner - Aimee Herbert",
        "description" : "Shows an example of a practitioner, Aimee Herbert, for the *AU Core Practitioner* profile, including HPI-I and name information.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/irvine-ronny-lawrence"
        },
        "name" : "Patient - Ronny Lawrence Irvine",
        "description" : "Shows an example of a patient, Ronny Lawrence Irvine, for the *AU Core Patient* profile, with an IHI, Medicare and DVA identifiers.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/kioma-pathology"
        },
        "name" : "Organization - Kioma Pathology Laboratory",
        "description" : "Shows an example of an organisation, Kioma Pathology Laboratory, for the *AU Core Organization* profile, with HPI-O, type as a pathology laboratory, contact information and physical address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/losch-sallie"
        },
        "name" : "Practitioner - Sallie Losch",
        "description" : "Shows an example of a practitioner, Sallie Losch, for the *AU Core Practitioner* profile, including HPI-I, name and APHRA information.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/mclaughlin-kimberlee"
        },
        "name" : "Practitioner - Kimberlee McLaughlin",
        "description" : "Shows an example of a practitioner, Kimberlee McLaughlin, for the *AU Core Practitioner* profile, including HPI-I and name information.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/mhr-consent-withdrawal"
        },
        "name" : "Consent - My Health Record Consent Withdrawal",
        "description" : "Shows an example of consent to upload X-ray results to the My Health Record withdrawn by patient for the *AU eRequesting MHR Consent Withdrawal* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-mhrconsentwithdrawal"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/mount-charlton-radiology"
        },
        "name" : "Organization - Mount Charlton Radiology",
        "description" : "Shows an example of an organisation, Mount Charlton Radiology, for the *AU Core Organization* profile, with HPI-O, type as a radiology practice, contact information and physical address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/observation-pregnancy-status"
        },
        "name" : "Observation - Pregnancy Status",
        "description" : "Shows an example of the *Pregnancy - Status (IPS)* profile, with a result of Pregnant. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/obsgynaeclinic"
        },
        "name" : "Encounter - OBGYN Outpatient Clinic",
        "description" : "Shows an example for the *AU Core Encounter* profile, representing a hospital outpatient obstetrics clinic visit. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/obstetrician-losch-sallie"
        },
        "name" : "PractitionerRole - Obstetrician and gynaecologist",
        "description" : "Shows an example of an obstetrician and gynaecologist, Sallie Losch, for the *AU Core PractitionerRole* profile, including Medicare Provider Number, associated organisation, role, and contact details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-bg-abs"
        },
        "name" : "ServiceRequest - Blood Group and Antibodies panel",
        "description" : "Shows an example of a request for a blood group and antibodies panel for the *AU eRequesting Pathology Request* profile. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-fbc-1"
        },
        "name" : "ServiceRequest - Full Blood Count",
        "description" : "Shows an example of a request for a Full Blood Count (FBC) for the *AU eRequesting Pathology Request* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-glu-1"
        },
        "name" : "ServiceRequest - Fasting Blood Glucose",
        "description" : "Shows an example of a request for a Fasting Blood Glucose test for the *AU eRequesting Pathology Request* profile. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-ironstudies"
        },
        "name" : "ServiceRequest - Iron studies",
        "description" : "Shows an example of a request for an Iron Studies group or panel of blood tests for the *AU eRequesting Pathology Request* profile. The request contains a context-specific sex parameter for clinical use and a status reason. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-obsus-1"
        },
        "name" : "ServiceRequest - Obstetric Ultrasound (Second Trimester)",
        "description" : "Shows an example of a request for an obstetric ultrasound in the second trimester for the *AU eRequesting Imaging Request* profile. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-urinemcs-1"
        },
        "name" : "ServiceRequest - Urine Microscopy, Culture and Sensitivity",
        "description" : "Shows an example of a request for a Urine Microscopy, Culture and Sensitivity test for the *AU eRequesting Pathology Request* profile. The request contains the precondition of nonfasting and pregnancy status supporting information. Patient: Remedios Belger.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/order-xray-1"
        },
        "name" : "ServiceRequest - X-ray",
        "description" : "Shows an example of a request for a chest X-ray for the *AU eRequesting Imaging Request* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/pathologist-herbert-aimee"
        },
        "name" : "PractitionerRole - Pathologist",
        "description" : "Shows an example of a Pathologist role for the *AU Core PractitionerRole* profile, including Medicare Provider Number, role, telecom and references to the associated Practitioner and Organization.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/practitioner-guthridge-jarred"
        },
        "name" : "Practitioner - Dr. Jarred Guthridge",
        "description" : "Shows an example of a practitioner, Jarred Guthridge, for the *AU Core Practitioner* profile, including HPI-I and name information.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/roberts-fred"
        },
        "name" : "Patient - Fred Roberts",
        "description" : "Shows an example of a patient, Fred Roberts, for the *AU Core Patient* profile, with an IHI, contact details, gender, birth date, address, and Indigenous status.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/task-communicationrequest-urgent-results-to-provider"
        },
        "name" : "Task - Communication Request - Urgent results communication to provider",
        "description" : "Shows an example of a task for fulfilment of a communication request for the *AU eRequesting Task Communication Request* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-communicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/taskfulfilment-imaging-1"
        },
        "name" : "Task - Imaging Fulfilment Task",
        "description" : "Shows an example of a task for fulfilment of an Imaging Request for the *AU eRequesting Task Diagnostic Request* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-diagnosticrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/taskfulfilment-pathology-1"
        },
        "name" : "Task - Pathology Fulfilment Task",
        "description" : "Shows an example of a task for fulfilment of a Pathology Request for the *AU eRequesting Task Diagnostic Request* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-diagnosticrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/taskgroup-imaging-1"
        },
        "name" : "Task - Imaging Task Group",
        "description" : "Shows an example of a group of tasks that are part of the same fulfilment group for an Imaging Request for the *AU eRequesting Task Group* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/taskgroup-pathology-1"
        },
        "name" : "Task - Pathology Task Group",
        "description" : "Shows an example of a group of tasks that are part of the same fulfilment group for a Pathology Request for the *AU eRequesting Task Group* profile. Patient: Fred Roberts.",
        "exampleCanonical" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "guidance.html"
            }
          ],
          "nameUrl" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "general-guidance.html"
                }
              ],
              "nameUrl" : "general-guidance.html",
              "title" : "General Guidance",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "workflow.html"
                }
              ],
              "nameUrl" : "workflow.html",
              "title" : "AU eRequesting Workflow Guidance",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "sex-and-gender.html"
                }
              ],
              "nameUrl" : "sex-and-gender.html",
              "title" : "Sex and Gender",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "auereqdi.html"
                }
              ],
              "nameUrl" : "auereqdi.html",
              "title" : "AU eRequesting Data for Interoperability Mappings",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "relationship.html"
                }
              ],
              "nameUrl" : "relationship.html",
              "title" : "Relationships to Other Specifications",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "variance.html"
                }
              ],
              "nameUrl" : "variance.html",
              "title" : "AU Variance Statement",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "future.html"
                }
              ],
              "nameUrl" : "future.html",
              "title" : "Future of AU eRequesting",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases.html"
            }
          ],
          "nameUrl" : "use-cases.html",
          "title" : "Use Cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Security and Privacy",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "fhirartifacts.html"
            }
          ],
          "nameUrl" : "fhirartifacts.html",
          "title" : "FHIR Artefacts",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "artifacts.html"
                }
              ],
              "nameUrl" : "artifacts.html",
              "title" : "Artefacts Summary",
              "generation" : "html"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "profiles-and-extensions.html"
                }
              ],
              "nameUrl" : "profiles-and-extensions.html",
              "title" : "Profiles and Extensions",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "terminology.html"
                }
              ],
              "nameUrl" : "terminology.html",
              "title" : "Terminology",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "capability-statements.html"
                }
              ],
              "nameUrl" : "capability-statements.html",
              "title" : "Actors and Capabilities",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "support.html"
            }
          ],
          "nameUrl" : "support.html",
          "title" : "Support",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "downloads.html"
                }
              ],
              "nameUrl" : "downloads.html",
              "title" : "Downloads",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "license.html"
                }
              ],
              "nameUrl" : "license.html",
              "title" : "License and Legal",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "input/pagecontent"
      },
      {
        "code" : "path-pages",
        "value" : "input/intro-notes"
      },
      {
        "code" : "path-pages",
        "value" : "fsh-generated/includes"
      },
      {
        "code" : "path-pages",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
