# Task - Communication Request - Urgent results communication to provider - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Task - Communication Request - Urgent results communication to provider**

## Example Task: Task - Communication Request - Urgent results communication to provider

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)

Tag: fulfilment of a task (Details: Resource Tag code fulfilment-task = 'fulfilment of a task')

**groupIdentifier**: Placer Group Number/EMC4542244-5624

**partOf**: [Task Fulfill the focal request](Task-taskgroup-imaging-1.md)

**status**: Requested

**intent**: order

**priority**: Urgent

**focus**: [CommunicationRequest: groupIdentifier = Placer Group Number: EMC4542244-5624; status = active; category = Alert; priority = urgent; medium = telephone; authoredOn = 2024-05-11; reasonCode = Urgent Results](CommunicationRequest-communicationrequest-urgent-results-to-provider.md)

**for**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**authoredOn**: 2024-05-11

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**owner**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "task-communicationrequest-urgent-results-to-provider",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-communicationrequest"
    ],
    "tag" : [
      {
        "system" : "http://terminology.hl7.org.au/CodeSystem/resource-tag",
        "code" : "fulfilment-task"
      }
    ]
  },
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC4542244-5624",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-center",
      "display" : "Elimbah Medical Center"
    }
  },
  "partOf" : [
    {
      "reference" : "Task/taskgroup-imaging-1"
    }
  ],
  "status" : "requested",
  "intent" : "order",
  "priority" : "urgent",
  "focus" : {
    "reference" : "CommunicationRequest/communicationrequest-urgent-results-to-provider"
  },
  "for" : {
    "reference" : "Patient/roberts-fred"
  },
  "authoredOn" : "2024-05-11",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "owner" : {
    "reference" : "Organization/mount-charlton-radiology"
  }
}

```
