# AU eRequesting Display Sequence - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Display Sequence**

##  Extension: AU eRequesting Display Sequence 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingDisplaySequence |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

This extension applies to the ServiceRequest resource and is used to represent the integer assigned to an individual test or service in a ServiceRequest that corresponds with the sequential position in which a test or service appears on a paper request form.

Sorting by display sequence enables more efficient reconciliation of paper and digital request data at the point of service provision.

This extension may be used on the following element(s):

* Element ID ServiceRequest

**Usages:**

* Use this Extension: [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* Examples for this Extension: [ServiceRequest/order-bg-abs](ServiceRequest-order-bg-abs.md), [ServiceRequest/order-fbc-1](ServiceRequest-order-fbc-1.md), [ServiceRequest/order-glu-1](ServiceRequest-order-glu-1.md), [ServiceRequest/order-ironstudies](ServiceRequest-order-ironstudies.md)...Show 3 more,[ServiceRequest/order-obsus-1](ServiceRequest-order-obsus-1.md),[ServiceRequest/order-urinemcs-1](ServiceRequest-order-urinemcs-1.md)and[ServiceRequest/order-xray-1](ServiceRequest-order-xray-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-displaysequence)

**Changes since version 1.0.0-ballot:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://hl7.org/fhir/R4/profiling.html#representation). 

 

 Other representations of profile: [CSV](StructureDefinition-au-erequesting-displaysequence.csv), [Excel](StructureDefinition-au-erequesting-displaysequence.xlsx), [Schematron](StructureDefinition-au-erequesting-displaysequence.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-displaysequence",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingDisplaySequence",
  "title" : "AU eRequesting Display Sequence",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This extension applies to the ServiceRequest resource and is used to represent the integer assigned to an individual test or service in a ServiceRequest that corresponds with the sequential position in which a test or service appears on a paper request form.\n\nSorting by display sequence enables more efficient reconciliation of paper and digital request data at the point of service provision.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Display sequence",
        "definition" : "This extension applies to the ServiceRequest resource and is used to represent the integer assigned to an individual test or service in a ServiceRequest that corresponds with the sequential position in which a test or service appears on a paper request form.\n\nSorting by display sequence enables more efficient reconciliation of paper and digital request data at the point of service provision."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "integer"
          }
        ]
      }
    ]
  }
}

```
