# AU eRequesting CommunicationRequest - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting CommunicationRequest**

## Resource Profile: AU eRequesting CommunicationRequest ( Abstract ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingCommunicationRequest |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for CommunicationRequest resources that are used to record, search, and fetch information about a communication request to be performed. It is based on the[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html)resource and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. 

### Profile Specific Implementation Guidance

* This abstract profile provides a shared base that is common across communication requests. It is not intended for direct implementation. Where a CommunicationRequest profile is defined for a specific purpose that profile **SHALL** be used: 
* Communication requests about providing a copy of the report to a patient or clinician **SHALL** use the [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md) profile
* Communication requests about communication with a patient from a filler **SHALL** use the [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md) profile
* Communication requests about communication from a filler to a clinical provider to notify them of urgent results **SHALL** use the [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) profile
 

**Usages:**

* Derived from this Profile: [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md), [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md) and [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-communicationrequest)

**Changes since version 1.0.0-ballot:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-communicationrequest.csv), [Excel](StructureDefinition-au-erequesting-communicationrequest.xlsx), [Schematron](StructureDefinition-au-erequesting-communicationrequest.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://build.fhir.org/ig/hl7au/au-fhir-core/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be ‘allowed’ by the system unless explicitly marked as “**SHALL NOT**”.

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/communicationrequest.html#search)**search parameter`GET [base]/CommunicationRequest?_id=[id]`Example:
1. GET [base]/CommunicationRequest?_id=2169591
**Implementation Notes:**Fetches a bundle with the requested CommunicationRequest, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-communicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingCommunicationRequest",
  "title" : "AU eRequesting CommunicationRequest",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for CommunicationRequest resources that are used to record, search, and fetch information about a communication request to be performed.  It is based on the [CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html) resource and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : true,
  "type" : "CommunicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CommunicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CommunicationRequest",
        "path" : "CommunicationRequest"
      },
      {
        "id" : "CommunicationRequest.groupIdentifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.groupIdentifier",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-localorderidentifier"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.groupIdentifier.type.coding",
        "path" : "CommunicationRequest.groupIdentifier.type.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN"
        }
      },
      {
        "id" : "CommunicationRequest.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.status",
        "fixedCode" : "active",
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.category",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.category",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.subject",
        "short" : "Patient that is the subject of the communication request",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.about",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.about",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path",
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag",
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.authoredOn",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.authoredOn",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.requester",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.requester",
        "short" : "Provider, Patient, or Organisation requesting the communication",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.recipient",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.recipient",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.sender",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.sender",
        "short" : "Organisation sending the communication",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.reasonCode",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.reasonCode",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org.au/fhir/ereq/ValueSet/au-erequesting-communicationrequest-reason"
        }
      }
    ]
  }
}

```
