# AU eRequesting CommunicationRequest CopyTo - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting CommunicationRequest CopyTo**

## Resource Profile: AU eRequesting CommunicationRequest CopyTo 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingCommunicationRequestCopyTo |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for a report to be copied to a clinician or patient as an additional recipient. A copy-to clinician is distinct from a request for urgent communication to a provider, as the priority may not be urgent. It is based on the[AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)profile and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the CommunicationRequest when conforming to this profile. 

**Usages:**

* Refer to this Profile: [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* Examples for this Profile: [CommunicationRequest/communicationrequest-copyto-gp](CommunicationRequest-communicationrequest-copyto-gp.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-communicationrequest-copyto)

**Changes since version 1.0.0-ballot:**

* The resource metadata has changed (description)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-communicationrequest-copyto.csv), [Excel](StructureDefinition-au-erequesting-communicationrequest-copyto.xlsx), [Schematron](StructureDefinition-au-erequesting-communicationrequest-copyto.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://build.fhir.org/ig/hl7au/au-fhir-core/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be ‘allowed’ by the system unless explicitly marked as “**SHALL NOT**”.

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/communicationrequest.html#search)**search parameter`GET [base]/CommunicationRequest?_id=[id]`Example:
1. GET [base]/CommunicationRequest?_id=2169591
**Implementation Notes:**Fetches a bundle with the requested CommunicationRequest, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-communicationrequest-copyto",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingCommunicationRequestCopyTo",
  "title" : "AU eRequesting CommunicationRequest CopyTo",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for a report to be copied to a clinician or patient as an additional recipient. A copy-to clinician is distinct from a request for urgent communication to a provider, as the priority may not be urgent. It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CommunicationRequest",
  "baseDefinition" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CommunicationRequest",
        "path" : "CommunicationRequest"
      },
      {
        "id" : "CommunicationRequest.category",
        "path" : "CommunicationRequest.category",
        "max" : "1"
      },
      {
        "id" : "CommunicationRequest.category.coding",
        "path" : "CommunicationRequest.category.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "notification"
        }
      },
      {
        "id" : "CommunicationRequest.doNotPerform",
        "path" : "CommunicationRequest.doNotPerform",
        "max" : "0"
      },
      {
        "id" : "CommunicationRequest.about",
        "path" : "CommunicationRequest.about",
        "short" : "Diagnostic request the copy-to communication is about",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path",
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
            ]
          }
        ]
      },
      {
        "id" : "CommunicationRequest.requester",
        "path" : "CommunicationRequest.requester",
        "short" : "Individual provider requesting the communication",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
            ]
          }
        ]
      },
      {
        "id" : "CommunicationRequest.recipient",
        "path" : "CommunicationRequest.recipient",
        "short" : "Individual provider or patient who is the intended recipient of the copy"
      },
      {
        "id" : "CommunicationRequest.reasonCode.coding",
        "path" : "CommunicationRequest.reasonCode.coding",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason",
          "code" : "copyto"
        }
      }
    ]
  }
}

```
