# AU eRequesting Clinical Context DocumentReference - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Clinical Context DocumentReference**

## Resource Profile: AU eRequesting Clinical Context DocumentReference 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingClinicalContextDocumentReference |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for representing clinical context using a DocumentReference resource to record, search, and fetch clinical context narrative information that provides an overview of the individual’s current clinical situation associated with a requested service. Clinical context is intended to describe the broader clinical background or circumstances relating to the request, supporting the service provider in making informed decisions about service delivery. It is based on the[DocumentReference](https://hl7.org/fhir/R4/documentreference.html)resource and identifies the additional constraints, extensions, vocabularies and value sets that**SHALL**be present in the DocumentReference when conforming to this profile. 

### Profile Specific Implementation Guidance

* Clinical context is defined as narrative information providing an overview of the individual’s current clinical situation associated with a requested service.
* This profile constrains `DocumentReference.content.attachment` to support narrative text only, ensuring consistency with the definition of clinical context from [AUeReqDI](auereqdi.md). To support this, the following constraints apply: 
* `DocumentReference.content.attachment` is mandatory to ensure that clinical context is always provided.
* `DocumentReference.content.attachment.contentType`is constrained to `text/plain`, limiting the representation to plain text narrative. This ensures that the content is both human-readable and interoperable across systems without additional rendering or format handling. Other formats such as PDF, DOC, DOCX, or HTML are not permitted.
* `DocumentReference.content.attachment.data` must be provided inline using base64 encoding. This ensures that the narrative is included in the resource, avoiding dependencies on external systems or links.
 
* These constraints are designed to ensure that clinical context is accessible, clearly represented, and consistently exchanged as part of AU eRequesting workflows.

**Usages:**

* Refer to this Profile: [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* Examples for this Profile: [DocumentReference/documentreference-clinical-context](DocumentReference-documentreference-clinical-context.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-clinicalcontext-documentreference)

**Changes since version 1.0.0-ballot:**

* The resource metadata has changed (description)

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-clinicalcontext-documentreference.csv), [Excel](StructureDefinition-au-erequesting-clinicalcontext-documentreference.xlsx), [Schematron](StructureDefinition-au-erequesting-clinicalcontext-documentreference.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://build.fhir.org/ig/hl7au/au-fhir-core/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be ‘allowed’ by the system unless explicitly marked as “**SHALL NOT**”.

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/resource.html#search)**search parameter`GET [base]/DocumentReference?_id=[id]`Example:
1. GET [base]/DocumentReference?_id=123654

**Implementation Notes:** Fetches a bundle with the requested DocumentReference, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-clinicalcontext-documentreference",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingClinicalContextDocumentReference",
  "title" : "AU eRequesting Clinical Context DocumentReference",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for representing clinical context using a DocumentReference resource to record, search, and fetch clinical context narrative information that provides an overview of the individual's current clinical situation associated with a requested service. Clinical context is intended to describe the broader clinical background or circumstances relating to the request, supporting the service provider in making informed decisions about service delivery.  It is based on the [DocumentReference](https://hl7.org/fhir/R4/documentreference.html) resource and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the DocumentReference when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference"
      },
      {
        "id" : "DocumentReference.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.status",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.type",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "107903-7"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.content",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.content.attachment",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.contentType",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.content.attachment.contentType",
        "min" : 1,
        "fixedCode" : "text/plain",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment.data",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "DocumentReference.content.attachment.data",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
