# ServiceRequest - Fasting Blood Glucose - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **ServiceRequest - Fasting Blood Glucose**

## Example ServiceRequest: ServiceRequest - Fasting Blood Glucose

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)

**AU eRequesting Display Sequence**: 1

**AU eRequesting Fasting Precondition**: Fasting

**identifier**: Placer Identifier/EMC1552642-1110-01

**requisition**: Placer Group Number/EMC1552642-1110

**status**: Active

**intent**: Order

**category**: Laboratory procedure

**code**: Glucose, Fasting

**quantity**: 1 1(Details: UCUM code1 = '1')

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); period = 2025-02-21 07:50:00+1000 --> 2025-02-21 08:20:00+1000](Encounter-obsgynaeclinic.md)

**occurrence**: 2025-02-21 08:00:00+1000

**authoredOn**: 2025-02-21

**requester**: [PractitionerRole Obstetrician and Gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

**supportingInfo**: [Pregnancy status](Observation-observation-pregnancy-status.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "order-glu-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-displaysequence",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-fastingprecondition",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "16985007",
            "display" : "Fasting"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
      "value" : "EMC1552642-1110-01",
      "assigner" : {
        "display" : "Elimbah Medical Center"
      }
    }
  ],
  "requisition" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ]
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1110",
    "assigner" : {
      "display" : "Elimbah Medical Center"
    }
  },
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "108252007",
          "display" : "Laboratory procedure"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "271062006",
        "display" : "Fasting blood glucose"
      }
    ],
    "text" : "Glucose, Fasting"
  },
  "quantityQuantity" : {
    "value" : 1,
    "system" : "http://unitsofmeasure.org",
    "code" : "1"
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "encounter" : {
    "reference" : "Encounter/obsgynaeclinic"
  },
  "occurrenceDateTime" : "2025-02-21T08:00:00+10:00",
  "authoredOn" : "2025-02-21",
  "requester" : {
    "reference" : "PractitionerRole/obstetrician-losch-sallie"
  },
  "supportingInfo" : [
    {
      "reference" : "Observation/observation-pregnancy-status",
      "display" : "Pregnancy status"
    }
  ]
}

```
