# PractitionerRole - Obstetrician and gynaecologist - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - Obstetrician and gynaecologist**

## Example PractitionerRole: PractitionerRole - Obstetrician and gynaecologist

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html)

**identifier**: Medicare Provider Number/2448931H

**practitioner**: [Practitioner Sallie LOSCH](Practitioner-losch-sallie.md)

**code**: Obstetrician and Gynaecologist

**specialty**: Obstetrics and gynaecology

**telecom**: ph: 0270104128(Work), [sallie.losch@example.com.au](mailto:sallie.losch@example.com.au)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "obstetrician-losch-sallie",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN"
          }
        ],
        "text" : "Medicare Provider Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2448931H"
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/losch-sallie"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0",
          "code" : "253913",
          "display" : "Obstetrician and Gynaecologist"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "309367003",
          "display" : "Obstetrician and gynaecologist"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "394585009",
          "display" : "Obstetrics and gynaecology"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0270104128",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "sallie.losch@example.com.au",
      "use" : "work"
    }
  ]
}

```
