# PractitionerRole - General practitioner - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - General practitioner**

## Example PractitionerRole: PractitionerRole - General practitioner

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html)

**identifier**: Medicare Provider Number/2448301T

**practitioner**: [Practitioner Jarred Guthridge](Practitioner-practitioner-guthridge-jarred.md)

**organization**: [Organization Elimbah Medical Center](Organization-elimbah-medical-center.md)

**code**: General Practitioner

**telecom**: ph: 0770109540, [jarred.guthridge@elimbahmedicalcentre.example.com.au](mailto:jarred.guthridge@elimbahmedicalcentre.example.com.au)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "generalpractitioner-guthridge-jarred",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN",
            "display" : "Medicare Provider Number"
          }
        ],
        "text" : "Medicare Provider Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2448301T"
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/practitioner-guthridge-jarred"
  },
  "organization" : {
    "reference" : "Organization/elimbah-medical-center"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "62247001"
        },
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0",
          "code" : "253111"
        }
      ],
      "text" : "General Practitioner"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0770109540"
    },
    {
      "system" : "email",
      "value" : "jarred.guthridge@elimbahmedicalcentre.example.com.au"
    }
  ]
}

```
