# Organization - Mount Charlton Radiology - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Mount Charlton Radiology**

## Example Organization: Organization - Mount Charlton Radiology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html)

**identifier**: HPI-O/8003623233373306

**type**: Radiology practice

**name**: Mount Charlton Radiology

**telecom**: [reception@mouncharltonradiology.example.net](mailto:reception@mouncharltonradiology.example.net), ph: (07) 555 02224(Work)

**address**: 7 Desleigh Rdge Mount Charlton QLD 4741 AU (work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "mount-charlton-radiology",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003623233373306"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
          "code" : "8520",
          "display" : "Pathology and Diagnostic Imaging Services"
        }
      ],
      "text" : "Radiology practice"
    }
  ],
  "name" : "Mount Charlton Radiology",
  "telecom" : [
    {
      "system" : "email",
      "value" : "reception@mouncharltonradiology.example.net",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(07) 555 02224",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "physical",
      "line" : ["7 Desleigh Rdge"],
      "city" : "Mount Charlton",
      "state" : "QLD",
      "postalCode" : "4741",
      "country" : "AU"
    }
  ]
}

```
