# Encounter - OBGYN Outpatient Clinic - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - OBGYN Outpatient Clinic**

## Example Encounter: Encounter - OBGYN Outpatient Clinic

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html)

**status**: Finished

**class**: [ActCode AMB](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-AMB): ambulatory

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**period**: 2025-02-21 07:50:00+1000 --> 2025-02-21 08:20:00+1000

### Locations

| | |
| :--- | :--- |
| - | **Location** |
| * | [Location Barney View Private Hospital](Location-barney-view-private-hospital.md) |

**serviceProvider**: [Organization Barney View Private Hospital](Organization-barney-view-private-hospital.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "obsgynaeclinic",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "period" : {
    "start" : "2025-02-21T07:50:00+10:00",
    "end" : "2025-02-21T08:20:00+10:00"
  },
  "location" : [
    {
      "location" : {
        "reference" : "Location/barney-view-private-hospital"
      }
    }
  ],
  "serviceProvider" : {
    "reference" : "Organization/barney-view-private-hospital"
  }
}

```
