# DocumentReference - Clinical Context - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **DocumentReference - Clinical Context**

## Example DocumentReference: DocumentReference - Clinical Context

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)

**status**: Current

**type**: Clinical note

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**date**: 2022-03-21 08:00:00+1000

**author**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

> **content**

### Attachments

| | | |
| :--- | :--- | :--- |
| - | **ContentType** | **Data** |
| * | text/plain | `MzMteWVhci1vbGQgZmVtYWxlIHByZXNlbnRpbmcgd2l0aCA0IGhvdXJzIG9mIGxvd2VyIGFiZG9taW5hbCBwYWluIGFuZCB1cmluZSBkaXBzdGljayBwb3NpdGl2ZSBmb3IgbGV1Y29jeXRlcy4=` |




## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "documentreference-clinical-context",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference"
    ]
  },
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "107903-7"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "date" : "2022-03-21T08:00:00+10:00",
  "author" : [
    {
      "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
    }
  ],
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/plain",
        "data" : "MzMteWVhci1vbGQgZmVtYWxlIHByZXNlbnRpbmcgd2l0aCA0IGhvdXJzIG9mIGxvd2VyIGFiZG9taW5hbCBwYWluIGFuZCB1cmluZSBkaXBzdGljayBwb3NpdGl2ZSBmb3IgbGV1Y29jeXRlcy4="
      }
    }
  ]
}

```
