# Coverage - DVA - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Coverage - DVA**

## Example Coverage: Coverage - DVA

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)

**identifier**: DVA Number (Gold)/NBUR9180

**status**: Active

**type**: veteran health program

**beneficiary**: [Ronny LAWRENCE IRVINE (official) Male, DoB: 1953-07-19 ( IHI: Austalian Healthcare Identifier - Individual#8003608833648421)](Patient-irvine-ronny-lawrence.md)

**relationship**: Self

**period**: 2023-01-01 --> (ongoing)

**payor**: Department of Veterans' Affairs (Identifier: ABN/23964290824)



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage-dva",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "DVG",
            "display" : "DVA Number (Gold Card)"
          }
        ],
        "text" : "DVA Number (Gold)"
      },
      "system" : "http://ns.electronichealth.net.au/id/dva",
      "value" : "NBUR9180"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
        "code" : "VET",
        "display" : "veteran health program"
      }
    ]
  },
  "beneficiary" : {
    "reference" : "Patient/irvine-ronny-lawrence"
  },
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ],
    "text" : "Self"
  },
  "period" : {
    "start" : "2023-01-01"
  },
  "payor" : [
    {
      "identifier" : {
        "type" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
              "code" : "XX"
            }
          ],
          "text" : "ABN"
        },
        "system" : "http://hl7.org.au/id/abn",
        "value" : "23964290824"
      },
      "display" : "Department of Veterans' Affairs"
    }
  ]
}

```
