# CommunicationRequest - Patient communication - do not perform - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **CommunicationRequest - Patient communication - do not perform**

## Example CommunicationRequest: CommunicationRequest - Patient communication - do not perform

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)

**groupIdentifier**: Placer Group Number/EMC1552642-1111

**status**: Active

**category**: reminder, instruction

**doNotPerform**: true

**medium**: email

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**about**: [ServiceRequest Ultrasonography in second trimester](ServiceRequest-order-obsus-1.md)

**authoredOn**: 2025-03-15 10:30:00+1000

**requester**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**recipient**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**sender**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)

**reasonCode**: Patient Request



## Resource Content

```json
{
  "resourceType" : "CommunicationRequest",
  "id" : "communicationrequest-donotperform",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient"
    ]
  },
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1111",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-center",
      "display" : "Elimbah Medical Center"
    }
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "reminder"
        }
      ],
      "text" : "reminder"
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "instruction"
        }
      ],
      "text" : "instruction"
    }
  ],
  "doNotPerform" : true,
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "EMAILWRIT"
        }
      ],
      "text" : "email"
    }
  ],
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "about" : [
    {
      "reference" : "ServiceRequest/order-obsus-1"
    }
  ],
  "authoredOn" : "2025-03-15T10:30:00+10:00",
  "requester" : {
    "reference" : "Patient/belger-remedios"
  },
  "recipient" : [
    {
      "reference" : "Patient/belger-remedios"
    }
  ],
  "sender" : {
    "reference" : "Organization/mount-charlton-radiology"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason",
          "code" : "patient",
          "display" : "Patient Request"
        }
      ]
    }
  ]
}

```
