# AU eRequesting Patient CapabilityStatement - AU eRequesting Implementation Guide v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Patient CapabilityStatement**

## CapabilityStatement: AU eRequesting Patient CapabilityStatement 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/CapabilityStatement/au-erequesting-patient | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingPatientCapabilityStatement |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This CapabilityStatement describes the basic rules for the[AU eRequesting Patient actor](ActorDefinition-au-erequesting-actor-patient.md)that is the digital interface that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU eRequesting Patient actor are defined in this CapabilityStatement. 

### Summary of Must Support and References Between Profiles

The table below identifies where a Profile has a Must Support reference to other profiles or resources (i.e., Target Profiles). This list is provided to clarify where additional profiles or resources may need to be supported if the AU eRequesting Patient actor supports a particular resource.

| | | |
| :--- | :--- | :--- |
| CommunicationRequest | [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html),[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) |
| Condition | [AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html) | [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) |
| Consent | [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md) | [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) |
| Coverage | [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | - |
| DocumentReference | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) |
| Encounter | [AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html) | [AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html),[AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html),[AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html),[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core Practitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html),[AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html),[AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html),[AU Core RelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/tructureDefinition-au-core-relatedperson.html),[Observation](http://hl7.org/fhir/R4/observation.html) |
| Location | [AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html) | [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html) |
| Observation | [Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html) | [Observation Pregnancy - Expected Delivery Date (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-edd-uv-ips.html),[Patient (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Patient-uv-ips.html) |
| Organization | [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html) | - |
| Patient | [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) | - |
| Practitioner | [AU Core Practitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html) | - |
| PractitionerRole | [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html) | [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html),[AU Core Practitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html) |
| Procedure | [AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html) | [AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html),[AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html),[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html),[DocumentReference](http://hl7.org/fhir/R4/documentreference.html),[Observation](http://hl7.org/fhir/R4/observation.html) |
| RelatedPerson | [AU Core RelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html) | [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html) |
| ServiceRequest | [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md),[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md),[AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html),[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html),[Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html) |
| Task | [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md),[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) | [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html),[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html),[AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html),[AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md),[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md),[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md),[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md),[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md),[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) |

 [Raw OpenAPI-Swagger Definition file](au-erequesting-patient.openapi.json) | [Download](au-erequesting-patient.openapi.json) 

## AU eRequesting Patient CapabilityStatement

* Implementation Guide Version: 1.0.0-ci-build 
* FHIR Version: 4.0.1 
* Supported Formats: **MAY** support `json`, **MAY** support `xml`
* Supported Patch Formats: **MAY** support `application/json-patch+json`
* Published on: 2025-10-20 07:23:52+0000 
* Published by: HL7 Australia 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

### SHALL Support the Following Implementation Guides

* [http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base](https://build.fhir.org/ig/hl7au/au-fhir-base/index.html)
* [http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core](https://build.fhir.org/ig/hl7au/au-fhir-core/index.html)

## FHIR RESTful Capabilities

### Mode: client

The AU eRequesting Patient actor **SHALL**:

1. Support at least one AU eRequesting ServiceRequest profile, and the conformance expectations for the ServiceRequest resource.
1. Implement the RESTful behavior according to the FHIR specification.

**Security**

> 

None defined.


### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [CommunicationRequest](#CommunicationRequest1-1) | Supported Profiles  [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)  [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)  [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md) | Y | Y |  |  | _id |  |  |  |
| [Condition](#Condition1-2) | Supported Profiles  [AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html) | Y | Y |  |  | _id |  |  |  |
| [Consent](#Consent1-3) | Supported Profiles  [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md) | Y | Y |  |  | _id |  |  |  |
| [Coverage](#Coverage1-4) | Supported Profiles  [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md) | Y | Y |  |  | _id |  |  |  |
| [DocumentReference](#DocumentReference1-5) | Supported Profiles  [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md) | Y | Y |  |  | _id |  |  |  |
| [Encounter](#Encounter1-6) | Supported Profiles  [AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html) | Y | Y |  |  | _id |  |  |  |
| [Location](#Location1-7) | Supported Profiles  [AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html) | Y | Y |  |  | _id |  |  |  |
| [Observation](#Observation1-8) | Supported Profiles  [Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html)  [Observation Pregnancy - Expected Delivery Date (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-edd-uv-ips.html) | Y | Y |  |  | _id |  |  |  |
| [Organization](#Organization1-9) | Supported Profiles  [AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html) | Y | Y |  |  | _id, identifier |  |  |  |
| [Patient](#Patient1-10) | Supported Profiles  [AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html)  [Patient (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Patient-uv-ips.html) | Y | Y |  |  | _id, identifier |  |  |  |
| [Practitioner](#Practitioner1-11) | Supported Profiles  [AU Core Practitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html) | Y | Y |  |  | _id, identifier |  |  |  |
| [PractitionerRole](#PractitionerRole1-12) | Supported Profiles  [AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html) | Y | Y |  |  | _id, identifier | `PractitionerRole:practitioner`,`PractitionerRole:organization` |  |  |
| [Procedure](#Procedure1-13) | Supported Profiles  [AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html) | Y | Y |  |  | _id |  |  |  |
| [RelatedPerson](#RelatedPerson1-14) | Supported Profiles  [AU Core RelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html) | Y | Y |  |  | _id |  |  |  |
| [ServiceRequest](#ServiceRequest1-15) | Supported Profiles  [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)  [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | Y | Y |  |  | _id, requisition, supporting-info | `ServiceRequest:patient`,`ServiceRequest:requester`,`ServiceRequest:encounter`,`ServiceRequest:supporting-info` |  |  |
| [Task](#Task1-16) | Supported Profiles  [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)  [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)  [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md) | Y | Y |  |  | _id, _lastUpdated, _tag, focus, group-identifier, owner, patient, requester, status, _lastUpdated+status+owner, owner+status, patient+status, requester+status | `Task:patient`,`Task:requester`,`Task:owner`,`Task:focus` |  |  |

-------

#### Resource Conformance: SHOULD CommunicationRequest

Core FHIR Resource

[CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
[AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
[AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)

Documentation
> 

If the AU eRequesting Patient actor supports the CommunicationRequest resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profiles and the conformance expectations for the CommunicationRequest resource.


Search Parameters


 

#### Resource Conformance: MAY Condition

Core FHIR Resource

[Condition](http://hl7.org/fhir/R4/condition.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Condition](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-condition.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Condition resource, the AU eRequesting Patient actor **SHALL** support the AU Core Condition profile, and the conformance expectations for the Condition resource.


Search Parameters


 

#### Resource Conformance: SHOULD Consent

Core FHIR Resource

[Consent](http://hl7.org/fhir/R4/consent.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)

Documentation
> 

If the AU eRequesting Patient actor supports the Consent resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting MHR Consent Withdrawal profile and the conformance expectations for the Consent resource.


Search Parameters


 

#### Resource Conformance: SHOULD Coverage

Core FHIR Resource

[Coverage](http://hl7.org/fhir/R4/coverage.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)

Documentation
> 

If the AU eRequesting Patient actor supports the Coverage resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting Coverage profile, and the conformance expectations for the Coverage resource.


Search Parameters


 

#### Resource Conformance: SHOULD DocumentReference

Core FHIR Resource

[DocumentReference](http://hl7.org/fhir/R4/documentreference.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)

Documentation
> 

If the AU eRequesting Patient actor supports the DocumentReference resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profile, and the conformance expectations for the DocumentReference resource.


Search Parameters


 

#### Resource Conformance: SHOULD Encounter

Core FHIR Resource

[Encounter](http://hl7.org/fhir/R4/encounter.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Encounter](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-encounter.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Encounter resource, the AU eRequesting Patient actor **SHALL** support the AU Core Encounter profile, and the conformance expectations for the Encounter resource.


Search Parameters


 

#### Resource Conformance: MAY Location

Core FHIR Resource

[Location](http://hl7.org/fhir/R4/location.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Location](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-location.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Location resource, the AU eRequesting Patient actor **SHALL** support the AU Core Location profile, and the conformance expectations for the Location resource.


Search Parameters


 

#### Resource Conformance: SHOULD Observation

Core FHIR Resource

[Observation](http://hl7.org/fhir/R4/observation.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[Observation Pregnancy - Status (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html)
[Observation Pregnancy - Expected Delivery Date (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Observation-pregnancy-edd-uv-ips.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Observation resource, the Observation Pregnancy - Status (IPS), the Observation Pregnancy - Expected Delivery Date (IPS) profiles and the conformance expectations for the Observation resource **SHALL** be supported.


Search Parameters


 

#### Resource Conformance: SHOULD Organization

Core FHIR Resource

[Organization](http://hl7.org/fhir/R4/organization.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Organization](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-organization.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Organization resource, the AU eRequesting Patient actor **SHALL** support the AU Core Organization profile, and the conformance expectations for the Organization resource.


Search Parameters


 

#### Resource Conformance: SHOULD Patient

Core FHIR Resource

[Patient](http://hl7.org/fhir/R4/patient.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Patient](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-patient.html)
[Patient (IPS)](https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Patient-uv-ips.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Patient resource, the AU Core Patient and Patient (IPS) profiles and the conformance expectations for the Patient resource **SHALL** be supported.


Search Parameters


 

#### Resource Conformance: SHOULD Practitioner

Core FHIR Resource

[Practitioner](http://hl7.org/fhir/R4/practitioner.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Practitioner](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitioner.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Practitioner resource, AU eRequesting Patient actor **SHALL** support the AU Core Practitioner profile, and the conformance expectations for the Practitioner resource.


Search Parameters


 

#### Resource Conformance: SHOULD PractitionerRole

Core FHIR Resource

[PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core PractitionerRole](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-practitionerrole.html)

Documentation
> 

If the AU eRequesting Patient actor supports the PractitionerRole resource, the AU eRequesting Patient actor **SHALL** support the AU Core PractitionerRole profile, and the conformance expectations for the PractitionerRole resource.

The AU eRequesting Patient actor **MAY** support the `_include` parameter for `PractitionerRole:practitioner` and `PractitionerRole:organization`


Search Parameters


 

#### Resource Conformance: MAY Procedure

Core FHIR Resource

[Procedure](http://hl7.org/fhir/R4/procedure.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core Procedure](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-procedure.html)

Documentation
> 

If the AU eRequesting Patient actor supports the Procedure resource, the AU eRequesting Patient actor **SHALL** support the AU Core Procedure profile, and the conformance expectations for the Procedure resource.


Search Parameters


 

#### Resource Conformance: MAY RelatedPerson

Core FHIR Resource

[RelatedPerson](http://hl7.org/fhir/R4/relatedperson.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU Core RelatedPerson](https://build.fhir.org/ig/hl7au/au-fhir-core/StructureDefinition-au-core-relatedperson.html)

Documentation
> 

If the AU eRequesting Patient actor supports the RelatedPerson resource, the AU eRequesting Patient actor **SHALL** support the AU Core profile, and the conformance expectations for the RelatedPerson resource.


Search Parameters


 

#### Resource Conformance: SHALL ServiceRequest

Core FHIR Resource

[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)

Reference Policy

Interaction summary

* **SHOULD** support `search-type`, `read`.

Supported Profiles
[AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)
[AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)

Documentation
> 

The AU eRequesting Patient actor **SHALL** support the ServiceRequest resource, at least one AU eRequesting ServiceRequest profile, and the conformance expectations for the ServiceRequest resource.

The AU eRequesting Patient actor **MAY** support the `_include` parameter for `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter` and `ServiceRequest:supporting-info`.


Search Parameters


 

#### Resource Conformance: SHOULD Task

Core FHIR Resource

[Task](http://hl7.org/fhir/R4/task.html)

Reference Policy

Interaction summary

* **SHOULD** support `read`, `search-type`.

Supported Profiles
[AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
[AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
[AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)

Documentation
> 

If the AU eRequesting Patient actor supports the Task resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profiles, and the conformance expectations for the Task resource.

The AU eRequesting Patient actor **MAY** support the `_include` parameter for `Task:patient`, `Task:requester`, `Task:owner`, `Task:focus`.


Search Parameters


Combined Search Parameters




## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "au-erequesting-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/CapabilityStatement/au-erequesting-patient",
  "version" : "1.0.0-ci-build",
  "name" : "AUeRequestingPatientCapabilityStatement",
  "title" : "AU eRequesting Patient CapabilityStatement",
  "status" : "active",
  "date" : "2025-10-20T07:23:52+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This CapabilityStatement describes the basic rules for the [AU eRequesting Patient actor](ActorDefinition-au-erequesting-actor-patient.html) that is the digital interface that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU eRequesting Patient actor are defined in this CapabilityStatement.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json", "xml"],
  "_format" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ],
  "patchFormat" : ["application/json-patch+json"],
  "_patchFormat" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "MAY"
        }
      ]
    }
  ],
  "implementationGuide" : [
    "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
    "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
  ],
  "_implementationGuide" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
          "valueCode" : "SHALL"
        }
      ]
    }
  ],
  "rest" : [
    {
      "mode" : "client",
      "documentation" : "The AU eRequesting Patient actor **SHALL**:\n1. Support at least one AU eRequesting ServiceRequest profile, and the conformance expectations for the ServiceRequest resource. \n1. Implement the RESTful behavior according to the FHIR specification.",
      "security" : {
        "description" : "None defined."
      },
      "resource" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "CommunicationRequest",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-urgentprovider"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the CommunicationRequest resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profiles and the conformance expectations for the CommunicationRequest resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Condition",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Condition resource, the AU eRequesting Patient actor **SHALL** support the AU Core Condition profile, and the conformance expectations for the Condition resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Consent",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-mhrconsentwithdrawal"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Consent resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting MHR Consent Withdrawal profile and the conformance expectations for the Consent resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Coverage",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-coverage"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Coverage resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting Coverage profile, and the conformance expectations for the Coverage resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "DocumentReference",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-clinicalcontext-documentreference"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the DocumentReference resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profile, and the conformance expectations for the DocumentReference resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Encounter",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Encounter resource, the AU eRequesting Patient actor **SHALL** support the AU Core Encounter profile, and the conformance expectations for the Encounter resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Location",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Location resource, the AU eRequesting Patient actor **SHALL** support the AU Core Location profile, and the conformance expectations for the Location resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Observation",
          "supportedProfile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Observation resource, the Observation Pregnancy - Status (IPS), the Observation Pregnancy - Expected Delivery Date (IPS) profiles and the conformance expectations for the Observation resource **SHALL** be supported.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Organization",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Organization resource, the AU eRequesting Patient actor **SHALL** support the AU Core Organization profile, and the conformance expectations for the Organization resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Organization-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Patient",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Patient resource, the AU Core Patient and Patient (IPS) profiles and the conformance expectations for the Patient resource **SHALL** be supported.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Patient-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "Practitioner",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Practitioner resource, AU eRequesting Patient actor **SHALL** support the AU Core Practitioner profile, and the conformance expectations for the Practitioner resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Practitioner-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            }
          ],
          "type" : "PractitionerRole",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the PractitionerRole resource, the AU eRequesting Patient actor **SHALL** support the AU Core PractitionerRole profile, and the conformance expectations for the PractitionerRole resource.\n\nThe AU eRequesting Patient actor **MAY** support the `_include` parameter for `PractitionerRole:practitioner` and `PractitionerRole:organization`",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : [
            "PractitionerRole:practitioner",
            "PractitionerRole:organization"
          ],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/PractitionerRole-identifier",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "Procedure",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Procedure resource, the AU eRequesting Patient actor **SHALL** support the AU Core Procedure profile, and the conformance expectations for the Procedure resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "MAY"
            }
          ],
          "type" : "RelatedPerson",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the RelatedPerson resource, the AU eRequesting Patient actor **SHALL** support the AU Core profile, and the conformance expectations for the RelatedPerson resource.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHALL"
            }
          ],
          "type" : "ServiceRequest",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-path",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ]
            }
          ],
          "documentation" : "The AU eRequesting Patient actor **SHALL** support the ServiceRequest resource, at least one AU eRequesting ServiceRequest profile, and the conformance expectations for the ServiceRequest resource.\n\nThe AU eRequesting Patient actor **MAY** support the `_include` parameter for `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter` and `ServiceRequest:supporting-info`.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            }
          ],
          "searchInclude" : [
            "ServiceRequest:patient",
            "ServiceRequest:requester",
            "ServiceRequest:encounter",
            "ServiceRequest:supporting-info"
          ],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "requisition",
              "definition" : "http://hl7.org/fhir/SearchParameter/ServiceRequest-requisition",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "supporting-info",
              "definition" : "http://hl7.org.au/fhir/SearchParameter/servicerequest-supporting-info",
              "type" : "reference"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
              "valueCode" : "SHOULD"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "_lastUpdated"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                },
                {
                  "url" : "required",
                  "valueString" : "owner"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "owner"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "patient"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                },
                {
                  "url" : "required",
                  "valueString" : "requester"
                },
                {
                  "url" : "required",
                  "valueString" : "status"
                }
              ],
              "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-parameter-combination"
            }
          ],
          "type" : "Task",
          "supportedProfile" : [
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-diagnosticrequest",
            "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-communicationrequest"
          ],
          "_supportedProfile" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ]
            }
          ],
          "documentation" : "If the AU eRequesting Patient actor supports the Task resource, the AU eRequesting Patient actor **SHALL** support the AU eRequesting profiles, and the conformance expectations for the Task resource.\n\nThe AU eRequesting Patient actor **MAY** support the `_include` parameter for `Task:patient`, `Task:requester`, `Task:owner`, `Task:focus`.",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "read"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHOULD"
                }
              ],
              "code" : "search-type"
            }
          ],
          "searchInclude" : ["Task:patient", "Task:requester", "Task:owner", "Task:focus"],
          "_searchInclude" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ]
            }
          ],
          "searchParam" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_id",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-id",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_lastUpdated",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-lastUpdated",
              "type" : "date",
              "documentation" : "The AU eRequesting Patient actor **MAY** support `multipleAnd`. The AU eRequesting Patient actor **MAY** support search comparators `gt`, `lt`, `ge`, `le`."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "_tag",
              "definition" : "http://hl7.org/fhir/SearchParameter/Resource-tag",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "focus",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-focus",
              "type" : "reference"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "group-identifier",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-group-identifier",
              "type" : "token"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "owner",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-owner",
              "type" : "reference",
              "documentation" : "The AU eRequesting Patient actor **MAY** support chained search owner.identifier using HPI-O and ABN identifiers as defined in the AU Core Organization profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "patient",
              "definition" : "http://hl7.org/fhir/SearchParameter/clinical-patient",
              "type" : "reference",
              "documentation" : "The AU eRequesting Patient actor **MAY** support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "requester",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-requester",
              "type" : "reference",
              "documentation" : "The AU eRequesting Patient actor **MAY** support chained search requester.identifier using Medicare Provider Number identifier as defined in the AU Core PractitionerRole profile."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "MAY"
                }
              ],
              "name" : "status",
              "definition" : "http://hl7.org/fhir/SearchParameter/Task-status",
              "type" : "token",
              "documentation" : "The AU eRequesting Patient actor **MAY** support `multipleOr`."
            }
          ]
        }
      ]
    }
  ]
}

```
