# AU Base BodyStructure - AU Base Implementation Guide v6.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Base BodyStructure**

## Resource Profile: AU Base BodyStructure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/StructureDefinition/au-bodystructure | *Version*:6.0.0-ci-build | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](generalguidance.md#maturity-levels): 1 | *Computable Name*:AUBaseBodyStructure |
| **Copyright/Legal**: HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile defines a body structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e.[profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs. 

### Usage Notes

**Usages:**

* Examples for this Profile: [BodyStructure/example0](BodyStructure-example0.md) and [BodyStructure/example1](BodyStructure-example1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.base|current/StructureDefinition/au-bodystructure)

**Changes since version 5.0.0:**

* The resource metadata has changed (title)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-bodystructure.csv), [Excel](StructureDefinition-au-bodystructure.xlsx), [Schematron](StructureDefinition-au-bodystructure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-bodystructure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/StructureDefinition/au-bodystructure",
  "version" : "6.0.0-ci-build",
  "name" : "AUBaseBodyStructure",
  "title" : "AU Base BodyStructure",
  "status" : "active",
  "date" : "2025-12-16T23:57:12+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Working Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile defines a body structure that localises core concepts, including terminology, for use in an Australian context. The purpose of this profile is to provide national level agreement on core localised concepts. This profile does not force conformance to core localised concepts. It enables implementers and modellers to make their own rules, i.e. [profiling](http://hl7.org/fhir/profiling.html), about how to support these concepts for specific implementation needs.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "openehr",
      "uri" : "http://openehr.org",
      "name" : "Open EHR Archetype Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "BodyStructure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/BodyStructure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "BodyStructure",
        "path" : "BodyStructure",
        "short" : "An identified anatomical structure in an Australian healthcare context",
        "constraint" : [
          {
            "key" : "inv-bodstr-0",
            "severity" : "error",
            "human" : "The body structure shall at least have location or description or an image",
            "expression" : "location.exists() or description.exists() or image.exists()"
          }
        ]
      },
      {
        "id" : "BodyStructure.morphology",
        "path" : "BodyStructure.morphology",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/bodystructure-code"
        }
      },
      {
        "id" : "BodyStructure.location",
        "path" : "BodyStructure.location",
        "condition" : ["inv-bodstr-0"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/body-site-1"
        }
      },
      {
        "id" : "BodyStructure.locationQualifier",
        "path" : "BodyStructure.locationQualifier",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/body-site-relative-site-qualifier-1"
        }
      },
      {
        "id" : "BodyStructure.description",
        "path" : "BodyStructure.description",
        "condition" : ["inv-bodstr-0"]
      },
      {
        "id" : "BodyStructure.image",
        "path" : "BodyStructure.image",
        "condition" : ["inv-bodstr-0"]
      }
    ]
  }
}

```
