# Communication Request Reason - AU Base Implementation Guide v6.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Communication Request Reason**

## CodeSystem: Communication Request Reason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason | *Version*:6.0.0-ci-build | |
| *Standards status:*[Deprecated](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](generalguidance.md#maturity-levels): 1 | *Computable Name*:CommunicationRequestReason |
| **Copyright/Legal**: HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved. | | |

 
The Communication Request Reason code system defines concepts that represent the reason codes for a communication request. 

 This code system is deprecated in AU Base as work undertaken in the [AU eRequesting](https://build.fhir.org/ig/hl7au/au-fhir-erequesting) project does no longer require these concepts for differentiating communication request reasons. 

### Usage Notes

 This Code system is referenced in the content logical definition of the following value sets: 

* This CodeSystem is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

**Changes since version 5.0.0:**

* New Content



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "communicationrequest-reason",
  "meta" : {
    "profile" : [
      "https://healthterminologies.gov.au/fhir/StructureDefinition/complete-code-system-4"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "deprecated",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason",
            "valueMarkdown" : "This code system is deprecated in AU Base as work undertaken in the [AU eRequesting](https://build.fhir.org/ig/hl7au/au-fhir-erequesting) project does no longer require these concepts for differentiating communication request reasons."
          }
        ]
      }
    }
  ],
  "url" : "http://terminology.hl7.org.au/CodeSystem/communicationrequest-reason",
  "version" : "6.0.0-ci-build",
  "name" : "CommunicationRequestReason",
  "title" : "Communication Request Reason",
  "status" : "retired",
  "experimental" : false,
  "date" : "2025-12-16T23:57:12+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Working Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The Communication Request Reason code system defines concepts that represent the reason codes for a communication request.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "HL7 Australia© 2018+; Licensed Under Creative Commons No Rights Reserved.",
  "caseSensitive" : true,
  "valueSet" : "http://terminology.hl7.org.au/ValueSet/communicationrequest-reason",
  "compositional" : false,
  "versionNeeded" : false,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "urgent",
      "display" : "Urgent Results",
      "definition" : "A request for results to be communicated urgently to the nominated recipient."
    },
    {
      "code" : "patient",
      "display" : "Patient Request",
      "definition" : "A patient's request about receiving communication from a service provider."
    },
    {
      "code" : "copyto",
      "display" : "Copy To",
      "definition" : "A request for results to be copied to an additional recipient."
    }
  ]
}

```
