# Profiles and Extensions - AU Base Implementation Guide v6.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles have been defined for this implementation guide.

#### Address

* [Australian Address](StructureDefinition-au-address.md)

#### AllergyIntolerance

* [AU Base AllergyIntolerance](StructureDefinition-au-allergyintolerance.md)

#### BodyStructure

* [AU Base BodyStructure](StructureDefinition-au-bodystructure.md)

#### Composition

* [AU Base Composition](StructureDefinition-au-composition.md)

#### Condition

* [AU Base Condition](StructureDefinition-au-condition.md)

#### Coverage

* [AU Base Coverage](StructureDefinition-au-coverage.md)

#### DiagnosticReport

* [AU Base DiagnosticReport](StructureDefinition-au-diagnosticreport.md) 
* [AU Base Diagnostic Imaging Report](StructureDefinition-au-imagingreport.md)
* [AU Base Pathology Report](StructureDefinition-au-pathologyreport.md)
 

#### Dosage

* [AU Base Dosage](StructureDefinition-au-dosage.md)

#### Encounter

* [AU Base Encounter](StructureDefinition-au-encounter.md)

#### HealthcareService

* [AU Base HealthcareService](StructureDefinition-au-healthcareservice.md)

#### Identifier

* [AU Accession Number](StructureDefinition-au-accessionnumber.md)
* [AU Ahpra Registration Number](StructureDefinition-au-ahpraregistrationnumber.md)
* [AU Australian Business Number](StructureDefinition-au-australianbusinessnumber.md)
* [AU Australian Company Number](StructureDefinition-au-australiancompanynumber.md)
* [AU Australian Registered Body Number](StructureDefinition-au-australianregistredbodynumber.md)
* [AU Care Agency Employee Identifier](StructureDefinition-au-careagencyemployeeidentifier.md)
* [AU CSP Registration Number](StructureDefinition-au-cspregistrationnumber.md)
* [AU Commonwealth Seniors Health Card Number](StructureDefinition-au-cwlthseniorshealthcardnumber.md)
* [AU Delivery Point Identifier](StructureDefinition-au-deliverypointidentifier.md)
* [AU DVA Number](StructureDefinition-au-dvanumber.md)
* [AU Employee Number](StructureDefinition-au-employeenumber.md)
* [AU ETP Prescription Identifier](StructureDefinition-au-etpprescriptionidentifier.md)
* [AU G-NAF Identifier](StructureDefinition-au-gnafidentifier.md)
* [AU Health Care Card Number](StructureDefinition-au-healthcarecardnumber.md)
* [AU HPI-I](StructureDefinition-au-hpii.md)
* [AU HPI-O](StructureDefinition-au-hpio.md)
* [AU IHI](StructureDefinition-au-ihi.md)
* [AU Insurance Member Number](StructureDefinition-au-insurancemembernumber.md)
* [AU Local Dispense Identifier](StructureDefinition-au-localdispenseidentifier.md)
* [AU Local Order Identifier](StructureDefinition-au-localorderidentifier.md)
* [AU Local Prescription Identifier](StructureDefinition-au-localprescriptionidentifier.md)
* [AU Local Report Identifier](StructureDefinition-au-localreportidentifier.md)
* [AU Location Specific Practice Number](StructureDefinition-au-locationspecificpracticenumber.md)
* [AU Medical Record Number](StructureDefinition-au-medicalrecordnumber.md)
* [AU Medicare Card Number](StructureDefinition-au-medicarecardnumber.md)
* [AU Medicare Provider Number](StructureDefinition-au-medicareprovidernumber.md)
* [AU NATA Accreditation Number](StructureDefinition-au-nataaccreditationnumber.md)
* [AU NATA Site Number](StructureDefinition-au-natasitenumber.md)
* [AU National Provider Identifier At Organisation](StructureDefinition-au-nationalprovideridentifieratorganisation.md)
* [AU PAI-D Identifier](StructureDefinition-au-paididentifier.md)
* [AU PAI-O Identifier](StructureDefinition-au-paioidentifier.md)
* [AU PBS Prescriber Number](StructureDefinition-au-pbsprescribernumber.md)
* [AU Pensioner Concession Card Number](StructureDefinition-au-pensionerconcessioncardnumber.md)
* [AU Pharmacy Approval Number](StructureDefinition-au-pharmacyapprovalnumber.md)
* [AU Patient Internal Identifier](StructureDefinition-au-pi.md)
* [AU Residential Aged Care Service Identifier](StructureDefinition-au-residentialagedcareserviceidentifier.md)

#### Immunization

* [AU Base Immunization](StructureDefinition-au-immunization.md)

#### List

* [AU Medicine List](StructureDefinition-au-medlist.md)

#### Location

* [AU Base Location](StructureDefinition-au-location.md)

#### Medication

* [AU Base Medication](StructureDefinition-au-medication.md)

#### MedicationAdministration

* [AU Base MedicationAdministration](StructureDefinition-au-medicationadministration.md)

#### MedicationDispense

* [AU Base MedicationDispense](StructureDefinition-au-medicationdispense.md)

#### MedicationRequest

* [AU Base MedicationRequest](StructureDefinition-au-medicationrequest.md)

#### MedicationStatement

* [AU Base MedicationStatement](StructureDefinition-au-medicationstatement.md)

#### Observation

* [AU Base Diagnostic Result](StructureDefinition-au-diagnosticresult.md)
* [AU Base Diagnostic Imaging Result](StructureDefinition-au-imagingresult.md)
* [AU Assertion of No Relevant Finding](StructureDefinition-au-norelevantfinding.md)
* [AU Base Pathology Result](StructureDefinition-au-pathologyresult.md)

#### Organization

* [AU Base Organization](StructureDefinition-au-organization.md)

#### Patient

* [AU Base Patient](StructureDefinition-au-patient.md)

#### Practitioner

* [AU Base Practitioner](StructureDefinition-au-practitioner.md)

#### PractitionerRole

* [AU Base PractitionerRole](StructureDefinition-au-practitionerrole.md)

#### Procedure

* [AU Base Procedure](StructureDefinition-au-procedure.md)

#### RelatedPerson

* [AU Base RelatedPerson](StructureDefinition-au-relatedperson.md)

#### ServiceRequest

* [AU Base Diagnostic Request](StructureDefinition-au-diagnosticrequest.md)
* [AU Base ServiceRequest](StructureDefinition-au-servicerequest.md)

#### Specimen

* [AU Base Specimen](StructureDefinition-au-specimen.md)

#### Substance

* [AU Base Substance](StructureDefinition-au-substance.md)

#### Extension

* [Australian Time Zone Usage](StructureDefinition-au-timezone-usage.md)

### Extensions

The following [extensions](http://hl7.org/fhir/R4/extensibility.html) have been defined as part of this guide. A [registry of standard extensions](http://hl7.org/fhir/R4/extensibility-registry.html) can be found in the FHIR specification and additional extensions may be registered on the HL7 FHIR registry at [http://hl7.org/fhir/registry](http://hl7.org/fhir/registry).

* [Address Identifier](StructureDefinition-address-identifier.md)
* [Ahpra Profession Details](StructureDefinition-ahpraprofession-details.md)
* [Ahpra Registration Details](StructureDefinition-ahpraregistration-details.md)
* [Associated Healthcare Service](StructureDefinition-associated-healthcareservice.md)
* [Australian Indigenous Status](StructureDefinition-indigenous-status.md)
* [Australian Time Zone](StructureDefinition-au-timezone.md)
* [Australian Time Zone Usage](StructureDefinition-au-timezone-usage.md)
* [Australian Veteran Status](StructureDefinition-veteran-status.md)
* [Author as a RelatedPerson](StructureDefinition-author-related-person.md)
* [Change Description](StructureDefinition-change-description.md)
* [Closing the Gap Registration](StructureDefinition-closing-the-gap-registration.md)
* [Contact Purpose](StructureDefinition-contact-purpose.md)
* [Date Accuracy Indicator](StructureDefinition-date-accuracy-indicator.md)
* [Date of Arrival in Australia](StructureDefinition-date-of-arrival.md)
* [Dispense Number](StructureDefinition-dispense-number.md)
* [Encounter Description](StructureDefinition-encounter-description.md)
* [Encryption Certificate PEM X509](StructureDefinition-encryption-certificate-pem-x509.md)
* [Ethnicity](StructureDefinition-ethnicity.md)
* [Subsidised Concurrent Supply](StructureDefinition-subsidised-concurrent-supply.md)
* [HL7 V2 Assigning Authority](StructureDefinition-au-assigningauthority.md)
* [HL7 V2 Receiving Application](StructureDefinition-au-receivingapplication.md)
* [HL7 V2 Receiving Facility](StructureDefinition-au-receivingfacility.md)
* [IHI Record Status](StructureDefinition-ihi-record-status.md)
* [IHI Status](StructureDefinition-ihi-status.md)
* [IHI Verification Date](StructureDefinition-ihi-verified-date.md)
* [Identifier Routability](StructureDefinition-identifier-routability.md)
* [Information Recipient](StructureDefinition-information-recipient.md)
* [Medication Brand Name](StructureDefinition-medication-brand-name.md)
* [Medication Generic Drug Name](StructureDefinition-medication-generic-name.md)
* [Long Term](StructureDefinition-medication-long-term.md)
* [Medication Strength](StructureDefinition-medication-strength.md)
* [Medication Type](StructureDefinition-medication-type.md)
* [Name Context](StructureDefinition-name-context.md)
* [No Fixed Address](StructureDefinition-no-fixed-address.md)
* [Result Copies To](StructureDefinition-result-copies-to.md)
* [Vaccine Vial Serial Number](StructureDefinition-vaccine-serial-number.md)

