# hl7.fhir.au.base#6.0.0-ci-build: AU Base Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [License and Legal](license.md)
* [Profiles and Extensions](profiles-and-extensions.md)
* [Search Parameters](search-parameters.md)
* [Terminology](terminology.md)
* [Sex and Gender](sexgender.md)
* [FHIR Artefacts](fhirartefacts.md)
* [General Guidance](generalguidance.md)
* [Change Log](changes.md)
* [Future of AU Base](future.md)
* [Support](support.md)
* [Relationship with other IGs](relationship.md)
* [Artefacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [Guidance](guidance.md)

## Resources

### CodeSystems

* [AU Digital Health Source System](CodeSystem-au-digital-health-source-system.md)
* [Location Type (Physical) AU](CodeSystem-au-location-physical-type.md)
* [Location Type AU](CodeSystem-au-location-type.md)
* [IdentifierType AU](CodeSystem-au-v2-0203.md)
* [DegreeLicenseCertificate AU](CodeSystem-au-v2-0360.md)
* [providerRole AU](CodeSystem-au-v2-0443.md)
* [ActCode AU](CodeSystem-au-v3-ActCode.md)
* [Communication Request Category](CodeSystem-communication-request-category.md)
* [Communication Request Reason](CodeSystem-communicationrequest-reason.md)
* [Contact Purpose](CodeSystem-contact-purpose.md)
* [Medication Type](CodeSystem-medication-type.md)
* [Medicine Item Change](CodeSystem-medicine-item-change.md)
* [Monthly Index of Medical Specialties (MIMS)](CodeSystem-mims-external.md)
* [Name Context](CodeSystem-name-context.md)
* [PBS Item Codes](CodeSystem-pbs-item-external.md)
* [Resource Tag](CodeSystem-resource-tag.md)
* [AU Recorded Sex or Gender Source Document Type](CodeSystem-rsg-source-document-type.md)
* [AU Recorded Sex or Gender Type](CodeSystem-rsg-type.md)
* [Service Provision Conditions Australian Concepts](CodeSystem-service-provision-conditions.md)
* [Task Business Status](CodeSystem-task-business-status.md)

### ValueSets

* [Accession Number Type](ValueSet-accession-number-type.md)
* [AMT Medicinal Product and Substances](ValueSet-amt-mp-codes.md)
* [Coverage Type and Self-Pay Codes - AU Extended](ValueSet-au-coverage-type-extended.md)
* [Jurisdiction ValueSet - AU Extended](ValueSet-au-jurisdiction-extended.md)
* [Location Type (Physical) - AU Extended](ValueSet-au-location-physical-type-extended.md)
* [AU Time Zone](ValueSet-au-timezone.md)
* [hl7VS-identifierType - AU Extended](ValueSet-au-v2-0203-extended.md)
* [hl7VS-degreeLicenseCertificate - AU Extended](ValueSet-au-v2-0360-extended.md)
* [hl7VS-providerRole - AU Extended](ValueSet-au-v2-0443-extended.md)
* [ActEncounterCode - AU Extended](ValueSet-au-v3-ActEncounterCode-extended.md)
* [ServiceDeliveryLocationRoleType - AU Extended](ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.md)
* [Contact Purpose](ValueSet-contact-purpose.md)
* [DVA Entitlement](ValueSet-dva-entitlement.md)
* [Medication Type](ValueSet-medication-type.md)
* [Medicine Item Change](ValueSet-medicine-item-change.md)
* [MIMS](ValueSet-mims.md)
* [Name Context](ValueSet-name-context.md)
* [Order Identifier Type](ValueSet-order-identifier-type.md)
* [PBS Item Codes](ValueSet-pbs-item.md)
* [AU Recorded Sex or Gender (RSG) Source Document Type](ValueSet-rsg-source-document-type.md)
* [AU Recorded Sex or Gender (RSG) Source](ValueSet-rsg-source.md)
* [AU Recorded Sex or Gender Type](ValueSet-rsg-type.md)
* [Service Provision Conditions Australian Concepts](ValueSet-service-provision-conditions.md)

### Complex-type Profiles

* [AU Accession Number](StructureDefinition-au-accessionnumber.md)
* [Australian Address](StructureDefinition-au-address.md)
* [AU Ahpra Registration Number](StructureDefinition-au-ahpraregistrationnumber.md)
* [AU Australian Business Number](StructureDefinition-au-australianbusinessnumber.md)
* [AU Australian Company Number](StructureDefinition-au-australiancompanynumber.md)
* [AU Australian Registered Body Number](StructureDefinition-au-australianregistredbodynumber.md)
* [AU Care Agency Employee Identifier](StructureDefinition-au-careagencyemployeeidentifier.md)
* [AU CSP Registration Number](StructureDefinition-au-cspregistrationnumber.md)
* [AU Commonwealth Seniors Health Card Number](StructureDefinition-au-cwlthseniorshealthcardnumber.md)
* [AU Delivery Point Identifier](StructureDefinition-au-deliverypointidentifier.md)
* [AU Base Dosage](StructureDefinition-au-dosage.md)
* [AU DVA Number](StructureDefinition-au-dvanumber.md)
* [AU Employee Number](StructureDefinition-au-employeenumber.md)
* [AU ETP Prescription Identifier](StructureDefinition-au-etpprescriptionidentifier.md)
* [AU G-NAF Identifier](StructureDefinition-au-gnafidentifier.md)
* [AU Health Care Card Number](StructureDefinition-au-healthcarecardnumber.md)
* [AU HPI-I](StructureDefinition-au-hpii.md)
* [AU HPI-O](StructureDefinition-au-hpio.md)
* [AU IHI](StructureDefinition-au-ihi.md)
* [AU Insurance Member Number](StructureDefinition-au-insurancemembernumber.md)
* [AU Local Dispense Identifier](StructureDefinition-au-localdispenseidentifier.md)
* [AU Local Order Identifier](StructureDefinition-au-localorderidentifier.md)
* [AU Local Prescription Identifier](StructureDefinition-au-localprescriptionidentifier.md)
* [AU Local Report Identifier](StructureDefinition-au-localreportidentifier.md)
* [AU Location Specific Practice Number](StructureDefinition-au-locationspecificpracticenumber.md)
* [AU Medical Record Number](StructureDefinition-au-medicalrecordnumber.md)
* [AU Medicare Card Number](StructureDefinition-au-medicarecardnumber.md)
* [AU Medicare Provider Number](StructureDefinition-au-medicareprovidernumber.md)
* [AU NATA Accreditation Number](StructureDefinition-au-nataaccreditationnumber.md)
* [AU NATA Site Number](StructureDefinition-au-natasitenumber.md)
* [AU National Provider Identifier At Organisation](StructureDefinition-au-nationalprovideridentifieratorganisation.md)
* [AU PAI-D Identifier](StructureDefinition-au-paididentifier.md)
* [AU PAI-O Identifier](StructureDefinition-au-paioidentifier.md)
* [AU PBS Prescriber Number](StructureDefinition-au-pbsprescribernumber.md)
* [AU Pensioner Concession Card Number](StructureDefinition-au-pensionerconcessioncardnumber.md)
* [AU Pharmacy Approval Number](StructureDefinition-au-pharmacyapprovalnumber.md)
* [AU Patient Internal Identifier](StructureDefinition-au-pi.md)
* [AU Residential Aged Care Service Identifier](StructureDefinition-au-residentialagedcareserviceidentifier.md)

### Resource Profiles

* [AU Base AllergyIntolerance](StructureDefinition-au-allergyintolerance.md)
* [AU Base BodyStructure](StructureDefinition-au-bodystructure.md)
* [AU Base Composition](StructureDefinition-au-composition.md)
* [AU Base Condition](StructureDefinition-au-condition.md)
* [AU Base Coverage](StructureDefinition-au-coverage.md)
* [AU Base DiagnosticReport](StructureDefinition-au-diagnosticreport.md)
* [AU Base Diagnostic Request](StructureDefinition-au-diagnosticrequest.md)
* [AU Base Diagnostic Result](StructureDefinition-au-diagnosticresult.md)
* [AU Base Encounter](StructureDefinition-au-encounter.md)
* [AU Base HealthcareService](StructureDefinition-au-healthcareservice.md)
* [AU Base Diagnostic Imaging Report](StructureDefinition-au-imagingreport.md)
* [AU Base Diagnostic Imaging Result](StructureDefinition-au-imagingresult.md)
* [AU Base Immunization](StructureDefinition-au-immunization.md)
* [AU Base Location](StructureDefinition-au-location.md)
* [AU Base Medication](StructureDefinition-au-medication.md)
* [AU Base MedicationAdministration](StructureDefinition-au-medicationadministration.md)
* [AU Base MedicationDispense](StructureDefinition-au-medicationdispense.md)
* [AU Base MedicationRequest](StructureDefinition-au-medicationrequest.md)
* [AU Base MedicationStatement](StructureDefinition-au-medicationstatement.md)
* [AU Medicine List](StructureDefinition-au-medlist.md)
* [AU Assertion of No Relevant Finding](StructureDefinition-au-norelevantfinding.md)
* [AU Base Organization](StructureDefinition-au-organization.md)
* [AU Base Pathology Report](StructureDefinition-au-pathologyreport.md)
* [AU Base Pathology Result](StructureDefinition-au-pathologyresult.md)
* [AU Base Patient](StructureDefinition-au-patient.md)
* [AU Base Practitioner](StructureDefinition-au-practitioner.md)
* [AU Base PractitionerRole](StructureDefinition-au-practitionerrole.md)
* [AU Base Procedure](StructureDefinition-au-procedure.md)
* [AU Base RelatedPerson](StructureDefinition-au-relatedperson.md)
* [AU Base ServiceRequest](StructureDefinition-au-servicerequest.md)
* [AU Base Specimen](StructureDefinition-au-specimen.md)
* [AU Base Substance](StructureDefinition-au-substance.md)

### Extensions

* [Address Identifier](StructureDefinition-address-identifier.md)
* [Ahpra Profession Details](StructureDefinition-ahpraprofession-details.md)
* [Ahpra Registration Details](StructureDefinition-ahpraregistration-details.md)
* [Associated Healthcare Service](StructureDefinition-associated-healthcareservice.md)
* [HL7 V2 Assigning Authority](StructureDefinition-au-assigningauthority.md)
* [HL7 V2 Receiving Application](StructureDefinition-au-receivingapplication.md)
* [HL7 V2 Receiving Facility](StructureDefinition-au-receivingfacility.md)
* [Australian Time Zone Usage](StructureDefinition-au-timezone-usage.md)
* [Australian Time Zone](StructureDefinition-au-timezone.md)
* [Author as a RelatedPerson](StructureDefinition-author-related-person.md)
* [Change Description](StructureDefinition-change-description.md)
* [Closing the Gap Registration](StructureDefinition-closing-the-gap-registration.md)
* [Contact Purpose](StructureDefinition-contact-purpose.md)
* [Date Accuracy Indicator](StructureDefinition-date-accuracy-indicator.md)
* [Date of Arrival in Australia](StructureDefinition-date-of-arrival.md)
* [Dispense Number](StructureDefinition-dispense-number.md)
* [Encounter Description](StructureDefinition-encounter-description.md)
* [Encryption Certificate PEM X509](StructureDefinition-encryption-certificate-pem-x509.md)
* [Ethnicity](StructureDefinition-ethnicity.md)
* [Identifier Routability](StructureDefinition-identifier-routability.md)
* [IHI Record Status](StructureDefinition-ihi-record-status.md)
* [IHI Status](StructureDefinition-ihi-status.md)
* [IHI Verification Date](StructureDefinition-ihi-verified-date.md)
* [Australian Indigenous Status](StructureDefinition-indigenous-status.md)
* [Information Recipient](StructureDefinition-information-recipient.md)
* [Medication Brand Name](StructureDefinition-medication-brand-name.md)
* [Medication Generic Drug Name](StructureDefinition-medication-generic-name.md)
* [Long Term](StructureDefinition-medication-long-term.md)
* [Medication Strength](StructureDefinition-medication-strength.md)
* [Medication Type](StructureDefinition-medication-type.md)
* [Name Context](StructureDefinition-name-context.md)
* [No Fixed Address](StructureDefinition-no-fixed-address.md)
* [Result Copies To](StructureDefinition-result-copies-to.md)
* [Subsidised Concurrent Supply](StructureDefinition-subsidised-concurrent-supply.md)
* [Vaccine Vial Serial Number](StructureDefinition-vaccine-serial-number.md)
* [Australian Veteran Status](StructureDefinition-veteran-status.md)

### ImplementationGuides

* [AU Base Implementation Guide](index.md)

### SearchParameters

* [EncounterDischargeDisposition](SearchParameter-encounter-discharge-disposition.md)
* [GenderIdentity](SearchParameter-gender-identity.md)
* [AustralianIndigenousStatus](SearchParameter-indigenous-status.md)
* [ServiceRequestSupportingInfo](SearchParameter-servicerequest-supporting-info.md)

### Examples

* [example0 (AllergyIntolerance)](AllergyIntolerance-example0.md)
* [example1 (AllergyIntolerance)](AllergyIntolerance-example1.md)
* [example2 (AllergyIntolerance)](AllergyIntolerance-example2.md)
* [example3 (AllergyIntolerance)](AllergyIntolerance-example3.md)
* [example0 (BodyStructure)](BodyStructure-example0.md)
* [example1 (BodyStructure)](BodyStructure-example1.md)
* [example0 (Bundle)](Bundle-example0.md)
* [Discharge Summary (Composition)](Composition-different-authors.md)
* [Stella's Final Wishes (Composition)](Composition-example0.md)
* [Discharge Summary (Composition)](Composition-multiple-information-recipients.md)
* [example0 (Condition)](Condition-example0.md)
* [dva (Coverage)](Coverage-dva.md)
* [private (Coverage)](Coverage-private.md)
* [example1 (Device)](Device-example1.md)
* [example0 (Encounter)](Encounter-example0.md)
* [example1 (Encounter)](Encounter-example1.md)
* [Telstra Health Secure Messaging Endpoint (Endpoint)](Endpoint-example0.md)
* [Cardiothoracic Services (HealthcareService)](HealthcareService-example0.md)
* [Albion Hospital Radiology Service (HealthcareService)](HealthcareService-example1.md)
* [Albion Hospital Pathology Service (HealthcareService)](HealthcareService-example2.md)
* [General Practitioner services (HealthcareService)](HealthcareService-example3.md)
* [Leafy Grove Home for the Aged (HealthcareService)](HealthcareService-example4.md)
* [Honourable Mark's Home For Aged Men (HealthcareService)](HealthcareService-example5.md)
* [example0 (Immunization)](Immunization-example0.md)
* [example1 (Immunization)](Immunization-example1.md)
* [example2 (Immunization)](Immunization-example2.md)
* [example3 (Immunization)](Immunization-example3.md)
* [example0 (List)](List-example0.md)
* [example1 (List)](List-example1.md)
* [example2 (List)](List-example2.md)
* [Current medicine list (List)](List-example3.md)
* [Downunder Hospital Blacktown (Location)](Location-example0.md)
* [example1 (Location)](Location-example1.md)
* [example2 (Location)](Location-example2.md)
* [example3 (Location)](Location-example3.md)
* [Telehealth (Location)](Location-example4.md)
* [Mobile, home-based (Location)](Location-example5.md)
* [Mobile, school-based (Location)](Location-example6.md)
* [Mobile, residential-care-based (Location)](Location-example7.md)
* [Leafy Grove (Location)](Location-example8.md)
* [example9 (Location)](Location-example9.md)
* [BrandProductwithBatchDetails0 (Medication)](Medication-BrandProductwithBatchDetails0.md)
* [BrandedPack0 (Medication)](Medication-BrandedPack0.md)
* [BrandedPack1 (Medication)](Medication-BrandedPack1.md)
* [BrandedPackSingleActiveIngredient0 (Medication)](Medication-BrandedPackSingleActiveIngredient0.md)
* [DoseBased (Medication)](Medication-DoseBased.md)
* [FourOrMoreActiveIngredientsProduct0 (Medication)](Medication-FourOrMoreActiveIngredientsProduct0.md)
* [GenericPack0 (Medication)](Medication-GenericPack0.md)
* [IngredientStrengthExtension0 (Medication)](Medication-IngredientStrengthExtension0.md)
* [StrengthExtension0 (Medication)](Medication-StrengthExtension0.md)
* [StrengthExtension1 (Medication)](Medication-StrengthExtension1.md)
* [TwoActiveIngredientsProduct0 (Medication)](Medication-TwoActiveIngredientsProduct0.md)
* [UnbrandedProduct0 (Medication)](Medication-UnbrandedProduct0.md)
* [UnbrandedProduct1 (Medication)](Medication-UnbrandedProduct1.md)
* [UnbrandedProduct2 (Medication)](Medication-UnbrandedProduct2.md)
* [UncodedProduct0 (Medication)](Medication-UncodedProduct0.md)
* [example0 (MedicationAdministration)](MedicationAdministration-example0.md)
* [example1 (MedicationAdministration)](MedicationAdministration-example1.md)
* [example0 (MedicationDispense)](MedicationDispense-example0.md)
* [example1 (MedicationDispense)](MedicationDispense-example1.md)
* [example0 (MedicationRequest)](MedicationRequest-example0.md)
* [example1 (MedicationRequest)](MedicationRequest-example1.md)
* [example2 (MedicationRequest)](MedicationRequest-example2.md)
* [example0 (MedicationStatement)](MedicationStatement-example0.md)
* [example1 (MedicationStatement)](MedicationStatement-example1.md)
* [example2 (MedicationStatement)](MedicationStatement-example2.md)
* [norelevantfinding-example0 (Observation)](Observation-norelevantfinding-example0.md)
* [norelevantfinding-example1 (Observation)](Observation-norelevantfinding-example1.md)
* [norelevantfinding-example2 (Observation)](Observation-norelevantfinding-example2.md)
* [norelevantfinding-example3 (Observation)](Observation-norelevantfinding-example3.md)
* [specimen-hepatitis-b-serology (Observation)](Observation-specimen-hepatitis-b-serology.md)
* [Test Org -DigitalHealth 5 (Organization)](Organization-5-8631-1.md)
* [Downunder Hospital (Organization)](Organization-example0.md)
* [Albion Hospital (Organization)](Organization-example1.md)
* [Holistic Medical Pty Ltd as trustee for Smith Family Trust (Organization)](Organization-example2.md)
* [Devonport Family Medicine Clinic (Organization)](Organization-example3.md)
* [Downunder Hospital (Organization)](Organization-example4.md)
* [The Corporation of the Synod of the Diocese of Nundah (Organization)](Organization-example5.md)
* [ACME Pathology (Organization)](Organization-example6.md)
* [DateAccuracyIndicatorAAAexample0 (Patient)](Patient-DateAccuracyIndicatorAAAexample0.md)
* [DateAccuracyIndicatorAAUexample1 (Patient)](Patient-DateAccuracyIndicatorAAUexample1.md)
* [DateAccuracyIndicatorUAAexample2 (Patient)](Patient-DateAccuracyIndicatorUAAexample2.md)
* [DateAccuracyIndicatorUEAexample3 (Patient)](Patient-DateAccuracyIndicatorUEAexample3.md)
* [DateAccuracyIndicatorUUUexample4 (Patient)](Patient-DateAccuracyIndicatorUUUexample4.md)
* [address-example0 (Patient)](Patient-address-example0.md)
* [address-example1 (Patient)](Patient-address-example1.md)
* [address-example2 (Patient)](Patient-address-example2.md)
* [address-example3 (Patient)](Patient-address-example3.md)
* [example-sex-and-gender (Patient)](Patient-example-sex-and-gender.md)
* [example0 (Patient)](Patient-example0.md)
* [example1 (Patient)](Patient-example1.md)
* [example2 (Patient)](Patient-example2.md)
* [example3 (Patient)](Patient-example3.md)
* [example4 (Patient)](Patient-example4.md)
* [example5 (Patient)](Patient-example5.md)
* [example6 (Patient)](Patient-example6.md)
* [example7 (Patient)](Patient-example7.md)
* [example8 (Patient)](Patient-example8.md)
* [example-sex-and-gender (Practitioner)](Practitioner-example-sex-and-gender.md)
* [example0 (Practitioner)](Practitioner-example0.md)
* [example1 (Practitioner)](Practitioner-example1.md)
* [example2 (Practitioner)](Practitioner-example2.md)
* [example3 (Practitioner)](Practitioner-example3.md)
* [example4 (Practitioner)](Practitioner-example4.md)
* [example0 (PractitionerRole)](PractitionerRole-example0.md)
* [example1 (PractitionerRole)](PractitionerRole-example1.md)
* [example2 (PractitionerRole)](PractitionerRole-example2.md)
* [example3 (PractitionerRole)](PractitionerRole-example3.md)
* [example4 (PractitionerRole)](PractitionerRole-example4.md)
* [example0 (Procedure)](Procedure-example0.md)
* [example1 (Procedure)](Procedure-example1.md)
* [example2 (Procedure)](Procedure-example2.md)
* [example-sex-and-gender (RelatedPerson)](RelatedPerson-example-sex-and-gender.md)
* [example0 (RelatedPerson)](RelatedPerson-example0.md)
* [example1 (RelatedPerson)](RelatedPerson-example1.md)
* [example2 (RelatedPerson)](RelatedPerson-example2.md)
* [example3 (RelatedPerson)](RelatedPerson-example3.md)
* [hepatitis-b-antibody (ServiceRequest)](ServiceRequest-hepatitis-b-antibody.md)
* [path-example0 (ServiceRequest)](ServiceRequest-path-example0.md)
* [serum (Specimen)](Specimen-serum.md)
* [example0 (Substance)](Substance-example0.md)
* [example1 (Substance)](Substance-example1.md)
* [example2 (Substance)](Substance-example2.md)
