# Substance - medication substance with two active ingredients - AU Base Implementation Guide v6.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Substance - medication substance with two active ingredients**

## Example Substance: Substance - medication substance with two active ingredients

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Base Substance](StructureDefinition-au-substance.md)

**code**: Atectura Breezhaler 125/62.5

> **ingredient****quantity**: 150 ug(Details: UCUM codeug = 'ug')/1 capsule(Details: SNOMED CT code385049006 = 'Capsule')**substance**:Indacaterol

> **ingredient****quantity**: 80 ug(Details: UCUM codeug = 'ug')/1 capsule(Details: SNOMED CT code385049006 = 'Capsule')**substance**:Mometasone furoate



## Resource Content

```json
{
  "resourceType" : "Substance",
  "id" : "example2",
  "meta" : {
    "profile" : ["http://hl7.org.au/fhir/StructureDefinition/au-substance"]
  },
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1500281000168107",
        "display" : "Atectura Breezhaler 125/62.5 powder for inhalation, capsule"
      }
    ],
    "text" : "Atectura Breezhaler 125/62.5"
  },
  "ingredient" : [
    {
      "quantity" : {
        "numerator" : {
          "value" : 150,
          "unit" : "ug",
          "system" : "http://unitsofmeasure.org",
          "code" : "ug"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "capsule",
          "system" : "http://snomed.info/sct",
          "code" : "385049006"
        }
      },
      "substanceCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "702801003",
            "display" : "Indacaterol"
          }
        ]
      }
    },
    {
      "quantity" : {
        "numerator" : {
          "value" : 80,
          "unit" : "ug",
          "system" : "http://unitsofmeasure.org",
          "code" : "ug"
        },
        "denominator" : {
          "value" : 1,
          "unit" : "capsule",
          "system" : "http://snomed.info/sct",
          "code" : "385049006"
        }
      },
      "substanceCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "395802006",
            "display" : "Mometasone furoate"
          }
        ]
      }
    }
  ]
}

```
