# Encounter - with description - AU Base Implementation Guide v6.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - with description**

## Example Encounter: Encounter - with description

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Base Encounter](StructureDefinition-au-encounter.md)

**Encounter Description**: Admitted for elective bronchoscopy for assessment of left lingular and bibasal pneumonia. No focal endobronchial pathology identified. No evidence of malignancy and no pathogens isolated on bronchial brushings and washings.

**status**: In Progress

**class**: [ActCode: ACUTE](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-ACUTE) (inpatient acute)

### Participants

| | |
| :--- | :--- |
| - | **Extension** |
| * |  |



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "example0",
  "meta" : {
    "profile" : ["http://hl7.org.au/fhir/StructureDefinition/au-encounter"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/encounter-description",
      "valueString" : "Admitted for elective bronchoscopy for assessment of left lingular and bibasal pneumonia. No focal endobronchial pathology identified. No evidence of malignancy and no pathogens isolated on bronchial brushings and washings."
    }
  ],
  "status" : "in-progress",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "ACUTE",
    "display" : "inpatient acute"
  },
  "participant" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Encounter.participant.actor",
          "valueReference" : {
            "reference" : "HealthcareService/example1"
          }
        }
      ]
    }
  ]
}

```
