# PTPersonBirthplace - HL7 PT FHIR Implementation Guide: Example IG Release 1 | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PTPersonBirthplace**

## Extension: PTPersonBirthplace 

| | |
| :--- | :--- |
| *Official URL*:http://example.com/fhir/example/StructureDefinition/PersonBirthplace-Pt | *Version*:1.0.0 |
| Active as of 2025-10-09 | *Computable Name*:PTPersonBirthplace |

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [PTPatient](StructureDefinition-Patient-Pt.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.pt.patient-admin-ig|current/StructureDefinition/PersonBirthplace-Pt)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PersonBirthplace-Pt.csv), [Excel](StructureDefinition-PersonBirthplace-Pt.xlsx), [Schematron](StructureDefinition-PersonBirthplace-Pt.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PersonBirthplace-Pt",
  "url" : "http://example.com/fhir/example/StructureDefinition/PersonBirthplace-Pt",
  "version" : "1.0.0",
  "name" : "PTPersonBirthplace",
  "status" : "active",
  "date" : "2025-10-09T11:10:27+00:00",
  "publisher" : "HL7 Portugal",
  "contact" : [
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.pt"
        },
        {
          "system" : "email",
          "value" : "info@hl7.pt"
        }
      ]
    },
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "email",
          "value" : "geral@hl7.pt",
          "use" : "work"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.3.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension.extension:country",
        "path" : "Extension.extension",
        "sliceName" : "country",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:country.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:country.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "country"
      },
      {
        "id" : "Extension.extension:country.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Extension.extension:county",
        "path" : "Extension.extension",
        "sliceName" : "county",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:county.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:county.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "county"
      },
      {
        "id" : "Extension.extension:county.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Extension.extension:municipality",
        "path" : "Extension.extension",
        "sliceName" : "municipality",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:municipality.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:municipality.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "municipality"
      },
      {
        "id" : "Extension.extension:municipality.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Extension.extension:parish",
        "path" : "Extension.extension",
        "sliceName" : "parish",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:parish.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:parish.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "parish"
      },
      {
        "id" : "Extension.extension:parish.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://example.com/fhir/example/StructureDefinition/PersonBirthplace-Pt"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
