# PTPatient - HL7 PT FHIR Implementation Guide: Example IG Release 1 | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PTPatient**

## Resource Profile: PTPatient 

| | |
| :--- | :--- |
| *Official URL*:http://example.com/fhir/example/StructureDefinition/Patient-Pt | *Version*:1.0.0 |
| Active as of 2025-10-09 | *Computable Name*:PTPatient |

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.pt.patient-admin-ig|current/StructureDefinition/Patient-Pt)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Patient-Pt.csv), [Excel](StructureDefinition-Patient-Pt.xlsx), [Schematron](StructureDefinition-Patient-Pt.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Patient-Pt",
  "url" : "http://example.com/fhir/example/StructureDefinition/Patient-Pt",
  "version" : "1.0.0",
  "name" : "PTPatient",
  "status" : "active",
  "date" : "2025-10-09T11:10:27+00:00",
  "publisher" : "HL7 Portugal",
  "contact" : [
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.pt"
        },
        {
          "system" : "email",
          "value" : "info@hl7.pt"
        }
      ]
    },
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "email",
          "value" : "geral@hl7.pt",
          "use" : "work"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.3.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.id",
        "path" : "Patient.id",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension",
        "path" : "Patient.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Patient.extension:occupation",
        "path" : "Patient.extension",
        "sliceName" : "occupation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/PersonOccupation-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:patient-record-type",
        "path" : "Patient.extension",
        "sliceName" : "patient-record-type",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/PersonRecordType-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:patient-enrollment-category-primarycare",
        "path" : "Patient.extension",
        "sliceName" : "patient-enrollment-category-primarycare",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/PatientEnrollmentCategoryPrimarycare-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.extension:nationality",
        "path" : "Patient.extension",
        "sliceName" : "nationality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/Nationality"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.extension:birthplace",
        "path" : "Patient.extension",
        "sliceName" : "birthplace",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/PersonBirthplace-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.identifier",
        "path" : "Patient.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "type"
            }
          ],
          "rules" : "closed"
        }
      },
      {
        "id" : "Patient.identifier.id",
        "path" : "Patient.identifier.id",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier.type.id",
        "path" : "Patient.identifier.type.id",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier.type.extension",
        "path" : "Patient.identifier.type.extension",
        "max" : "0"
      },
      {
        "id" : "Patient.identifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://example.com/fhir/example/ValueSet/patient-identifier-type"
        }
      },
      {
        "id" : "Patient.identifier:residentCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "residentCardNumber",
        "short" : "Número do Título de Residência",
        "definition" : "Número do Título de Residência",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:residentCardNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "PRC",
          "display" : "Número do Título de Residência"
        }
      },
      {
        "id" : "Patient.identifier:residentCardNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número do Título de Residência"
      },
      {
        "id" : "Patient.identifier:citizenshipCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "citizenshipCardNumber",
        "short" : "Número de Identificação Civil",
        "definition" : "Número de Identificação Civil",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:citizenshipCardNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "CZ",
          "display" : "Número de Identificação Civil"
        }
      },
      {
        "id" : "Patient.identifier:citizenshipCardNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número de Identificação Civil"
      },
      {
        "id" : "Patient.identifier:taxIdNumber",
        "path" : "Patient.identifier",
        "sliceName" : "taxIdNumber",
        "short" : "Número de Identificação Fiscal",
        "definition" : "Número de Identificação Fiscal",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:taxIdNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "TAX",
          "display" : "Número de Identificação Fiscal"
        }
      },
      {
        "id" : "Patient.identifier:taxIdNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número de Identificação Fiscal"
      },
      {
        "id" : "Patient.identifier:socialSecurityNumber",
        "path" : "Patient.identifier",
        "sliceName" : "socialSecurityNumber",
        "short" : "Número de Identificação da Segurança Social",
        "definition" : "Número de Identificação da Segurança Social",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:socialSecurityNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "SS",
          "display" : "Número de Segurança Social"
        }
      },
      {
        "id" : "Patient.identifier:socialSecurityNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número de Identificação da Segurança Social"
      },
      {
        "id" : "Patient.identifier:healthCardNumber",
        "path" : "Patient.identifier",
        "sliceName" : "healthCardNumber",
        "short" : "Número Nacional do Utente",
        "definition" : "Número Nacional do Utente",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:healthCardNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "HC",
          "display" : "Número Nacional do Utente"
        }
      },
      {
        "id" : "Patient.identifier:healthCardNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número Nacional do Utente"
      },
      {
        "id" : "Patient.identifier:passportNumber",
        "path" : "Patient.identifier",
        "sliceName" : "passportNumber",
        "short" : "Número do Passaporte",
        "definition" : "Número do Passaporte",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:passportNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "PPN",
          "display" : "Número de Passaporte"
        }
      },
      {
        "id" : "Patient.identifier:passportNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número do Passaporte"
      },
      {
        "id" : "Patient.identifier:patientInternalIdentifier",
        "path" : "Patient.identifier",
        "sliceName" : "patientInternalIdentifier",
        "short" : "Número Interno do Utente",
        "definition" : "Número Interno do Utente",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:patientInternalIdentifier.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "PI",
          "display" : "Número Interno do Utente"
        }
      },
      {
        "id" : "Patient.identifier:patientInternalIdentifier.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número Interno do Utente"
      },
      {
        "id" : "Patient.identifier:militaryIDNumber",
        "path" : "Patient.identifier",
        "sliceName" : "militaryIDNumber",
        "short" : "Número da Cédula Militar",
        "definition" : "Número da Cédula Militar",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:militaryIDNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "MI",
          "display" : "Número da Cédula Militar"
        }
      },
      {
        "id" : "Patient.identifier:militaryIDNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Número da Cédula Militar"
      },
      {
        "id" : "Patient.identifier:medicalRecordNumber",
        "path" : "Patient.identifier",
        "sliceName" : "medicalRecordNumber",
        "short" : "Numero de processo Clinico",
        "definition" : "Numero de processo Clinico",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:medicalRecordNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "MR",
          "display" : "Numero de processo Clinico"
        }
      },
      {
        "id" : "Patient.identifier:medicalRecordNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Numero de processo Clinico"
      },
      {
        "id" : "Patient.identifier:familyRecordNumber",
        "path" : "Patient.identifier",
        "sliceName" : "familyRecordNumber",
        "short" : "Numero de processo clinico familiar",
        "definition" : "Numero de processo clinico familiar",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:familyRecordNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "MR",
          "display" : "Numero de processo clinico familiar"
        }
      },
      {
        "id" : "Patient.identifier:familyRecordNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Numero de processo clinico familiar"
      },
      {
        "id" : "Patient.identifier:birthRegistryNumber",
        "path" : "Patient.identifier",
        "sliceName" : "birthRegistryNumber",
        "short" : "Cédula de Nascimento",
        "definition" : "Cédula de Nascimento",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Patient.identifier:birthRegistryNumber.type.coding",
        "path" : "Patient.identifier.type.coding",
        "patternCoding" : {
          "system" : "http://hl7.pt/fhir/identifier-type",
          "code" : "BR",
          "display" : "Cédula de Nascimento"
        }
      },
      {
        "id" : "Patient.identifier:birthRegistryNumber.type.text",
        "path" : "Patient.identifier.type.text",
        "patternString" : "Cédula de Nascimento"
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.telecom",
        "path" : "Patient.telecom",
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.extension:addressType",
        "path" : "Patient.address.extension",
        "sliceName" : "addressType",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressType-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.extension:municipality",
        "path" : "Patient.address.extension",
        "sliceName" : "municipality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressMunicipality-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.extension:county",
        "path" : "Patient.address.extension",
        "sliceName" : "county",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressCounty-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.extension:parish",
        "path" : "Patient.address.extension",
        "sliceName" : "parish",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressParish-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.address.extension:nuts",
        "path" : "Patient.address.extension",
        "sliceName" : "nuts",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressNuts-Pt"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact",
        "path" : "Patient.contact",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Patient.contact.address.extension:addressType",
        "path" : "Patient.contact.address.extension",
        "sliceName" : "addressType",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressType-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.address.extension:municipality",
        "path" : "Patient.contact.address.extension",
        "sliceName" : "municipality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressMunicipality-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.address.extension:county",
        "path" : "Patient.contact.address.extension",
        "sliceName" : "county",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressCounty-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.address.extension:parish",
        "path" : "Patient.contact.address.extension",
        "sliceName" : "parish",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressParish-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.contact.address.extension:nuts",
        "path" : "Patient.contact.address.extension",
        "sliceName" : "nuts",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/AddressNuts-Pt"
            ]
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner.extension:patient-primary-care-period",
        "path" : "Patient.generalPractitioner.extension",
        "sliceName" : "patient-primary-care-period",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://example.com/fhir/example/StructureDefinition/PatientPrimaryCarePeriod-Pt"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
