# PTOrganization - HL7 PT FHIR Implementation Guide: Example IG Release 1 | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PTOrganization**

## Resource Profile: PTOrganization 

| | |
| :--- | :--- |
| *Official URL*:http://example.com/fhir/example/StructureDefinition/Organization-Pt | *Version*:1.0.0 |
| Active as of 2025-10-09 | *Computable Name*:PTOrganization |

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.pt.patient-admin-ig|current/StructureDefinition/Organization-Pt)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-Pt.csv), [Excel](StructureDefinition-Organization-Pt.xlsx), [Schematron](StructureDefinition-Organization-Pt.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-Pt",
  "url" : "http://example.com/fhir/example/StructureDefinition/Organization-Pt",
  "version" : "1.0.0",
  "name" : "PTOrganization",
  "status" : "active",
  "date" : "2025-10-09T11:10:27+00:00",
  "publisher" : "HL7 Portugal",
  "contact" : [
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.pt"
        },
        {
          "system" : "email",
          "value" : "info@hl7.pt"
        }
      ]
    },
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "email",
          "value" : "geral@hl7.pt",
          "use" : "work"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.3.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.id",
        "path" : "Organization.id",
        "min" : 1
      },
      {
        "id" : "Organization.identifier.id",
        "path" : "Organization.identifier.id",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier.type",
        "path" : "Organization.identifier.type",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier.period",
        "path" : "Organization.identifier.period",
        "max" : "0"
      },
      {
        "id" : "Organization.identifier.assigner",
        "path" : "Organization.identifier.assigner",
        "max" : "0"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "max" : "0"
      },
      {
        "id" : "Organization.alias",
        "path" : "Organization.alias",
        "max" : "0"
      },
      {
        "id" : "Organization.telecom",
        "path" : "Organization.telecom",
        "max" : "0"
      },
      {
        "id" : "Organization.address",
        "path" : "Organization.address",
        "max" : "0"
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "max" : "0"
      },
      {
        "id" : "Organization.contact",
        "path" : "Organization.contact",
        "max" : "0"
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "max" : "0"
      }
    ]
  }
}

```
