# PTMessageHeader - HL7 PT FHIR Implementation Guide: Example IG Release 1 | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PTMessageHeader**

## Resource Profile: PTMessageHeader 

| | |
| :--- | :--- |
| *Official URL*:http://example.com/fhir/example/StructureDefinition/MessageHeader-Pt | *Version*:1.0.0 |
| Active as of 2025-10-09 | *Computable Name*:PTMessageHeader |

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.pt.patient-admin-ig|current/StructureDefinition/MessageHeader-Pt)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MessageHeader-Pt.csv), [Excel](StructureDefinition-MessageHeader-Pt.xlsx), [Schematron](StructureDefinition-MessageHeader-Pt.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MessageHeader-Pt",
  "url" : "http://example.com/fhir/example/StructureDefinition/MessageHeader-Pt",
  "version" : "1.0.0",
  "name" : "PTMessageHeader",
  "status" : "active",
  "date" : "2025-10-09T11:10:27+00:00",
  "publisher" : "HL7 Portugal",
  "contact" : [
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.pt"
        },
        {
          "system" : "email",
          "value" : "info@hl7.pt"
        }
      ]
    },
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "email",
          "value" : "geral@hl7.pt",
          "use" : "work"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.3.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MessageHeader",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MessageHeader",
        "path" : "MessageHeader"
      },
      {
        "id" : "MessageHeader.id",
        "path" : "MessageHeader.id",
        "min" : 1
      },
      {
        "id" : "MessageHeader.meta",
        "path" : "MessageHeader.meta",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.implicitRules",
        "path" : "MessageHeader.implicitRules",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.language",
        "path" : "MessageHeader.language",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.text",
        "path" : "MessageHeader.text",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.contained",
        "path" : "MessageHeader.contained",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.event[x]",
        "path" : "MessageHeader.event[x]",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://example.com/fhir/example/ValueSet/vs-patient-identity-events"
        }
      },
      {
        "id" : "MessageHeader.destination.target",
        "path" : "MessageHeader.destination.target",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.destination.receiver.type",
        "path" : "MessageHeader.destination.receiver.type",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.destination.receiver.identifier",
        "path" : "MessageHeader.destination.receiver.identifier",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.destination.receiver.display",
        "path" : "MessageHeader.destination.receiver.display",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.sender.type",
        "path" : "MessageHeader.sender.type",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.sender.identifier",
        "path" : "MessageHeader.sender.identifier",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.sender.display",
        "path" : "MessageHeader.sender.display",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.enterer.type",
        "path" : "MessageHeader.enterer.type",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.enterer.identifier",
        "path" : "MessageHeader.enterer.identifier",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.enterer.display",
        "path" : "MessageHeader.enterer.display",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.author",
        "path" : "MessageHeader.author",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.source.software",
        "path" : "MessageHeader.source.software",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.source.version",
        "path" : "MessageHeader.source.version",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.source.contact",
        "path" : "MessageHeader.source.contact",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.responsible",
        "path" : "MessageHeader.responsible",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.reason",
        "path" : "MessageHeader.reason",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.focus.type",
        "path" : "MessageHeader.focus.type",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.focus.identifier",
        "path" : "MessageHeader.focus.identifier",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.focus.display",
        "path" : "MessageHeader.focus.display",
        "max" : "0"
      },
      {
        "id" : "MessageHeader.definition",
        "path" : "MessageHeader.definition",
        "max" : "0"
      }
    ]
  }
}

```
