# PTCoverage - HL7 PT FHIR Implementation Guide: Example IG Release 1 | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PTCoverage**

## Resource Profile: PTCoverage 

| | |
| :--- | :--- |
| *Official URL*:http://example.com/fhir/example/StructureDefinition/Coverage-Pt | *Version*:1.0.0 |
| Active as of 2025-10-09 | *Computable Name*:PTCoverage |

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.pt.patient-admin-ig|current/StructureDefinition/Coverage-Pt)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Coverage-Pt.csv), [Excel](StructureDefinition-Coverage-Pt.xlsx), [Schematron](StructureDefinition-Coverage-Pt.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Coverage-Pt",
  "url" : "http://example.com/fhir/example/StructureDefinition/Coverage-Pt",
  "version" : "1.0.0",
  "name" : "PTCoverage",
  "status" : "active",
  "date" : "2025-10-09T11:10:27+00:00",
  "publisher" : "HL7 Portugal",
  "contact" : [
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.pt"
        },
        {
          "system" : "email",
          "value" : "info@hl7.pt"
        }
      ]
    },
    {
      "name" : "HL7 Portugal",
      "telecom" : [
        {
          "system" : "email",
          "value" : "geral@hl7.pt",
          "use" : "work"
        }
      ]
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.3.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage"
      },
      {
        "id" : "Coverage.id",
        "path" : "Coverage.id",
        "min" : 1
      },
      {
        "id" : "Coverage.identifier",
        "path" : "Coverage.identifier",
        "max" : "0"
      },
      {
        "id" : "Coverage.type",
        "path" : "Coverage.type",
        "max" : "0"
      },
      {
        "id" : "Coverage.policyHolder",
        "path" : "Coverage.policyHolder",
        "max" : "0"
      },
      {
        "id" : "Coverage.subscriber.id",
        "path" : "Coverage.subscriber.id",
        "max" : "0"
      },
      {
        "id" : "Coverage.subscriber.type",
        "path" : "Coverage.subscriber.type",
        "max" : "0"
      },
      {
        "id" : "Coverage.subscriber.identifier",
        "path" : "Coverage.subscriber.identifier",
        "max" : "0"
      },
      {
        "id" : "Coverage.subscriber.display",
        "path" : "Coverage.subscriber.display",
        "max" : "0"
      },
      {
        "id" : "Coverage.subscriberId",
        "path" : "Coverage.subscriberId",
        "max" : "0"
      },
      {
        "id" : "Coverage.beneficiary",
        "path" : "Coverage.beneficiary",
        "mustSupport" : true
      },
      {
        "id" : "Coverage.beneficiary.id",
        "path" : "Coverage.beneficiary.id",
        "max" : "0"
      },
      {
        "id" : "Coverage.beneficiary.type",
        "path" : "Coverage.beneficiary.type",
        "max" : "0"
      },
      {
        "id" : "Coverage.beneficiary.identifier",
        "path" : "Coverage.beneficiary.identifier",
        "max" : "0"
      },
      {
        "id" : "Coverage.beneficiary.display",
        "path" : "Coverage.beneficiary.display",
        "max" : "0"
      },
      {
        "id" : "Coverage.dependent",
        "path" : "Coverage.dependent",
        "max" : "0"
      },
      {
        "id" : "Coverage.relationship",
        "path" : "Coverage.relationship",
        "max" : "0"
      },
      {
        "id" : "Coverage.period.id",
        "path" : "Coverage.period.id",
        "max" : "0"
      },
      {
        "id" : "Coverage.payor",
        "path" : "Coverage.payor",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Organization"]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Coverage.payor.id",
        "path" : "Coverage.payor.id",
        "max" : "0"
      },
      {
        "id" : "Coverage.payor.type",
        "path" : "Coverage.payor.type",
        "max" : "0"
      },
      {
        "id" : "Coverage.payor.identifier",
        "path" : "Coverage.payor.identifier",
        "max" : "0"
      },
      {
        "id" : "Coverage.payor.display",
        "path" : "Coverage.payor.display",
        "max" : "0"
      },
      {
        "id" : "Coverage.class",
        "path" : "Coverage.class",
        "max" : "0"
      },
      {
        "id" : "Coverage.order",
        "path" : "Coverage.order",
        "max" : "0"
      },
      {
        "id" : "Coverage.network",
        "path" : "Coverage.network",
        "max" : "0"
      },
      {
        "id" : "Coverage.costToBeneficiary",
        "path" : "Coverage.costToBeneficiary",
        "max" : "0"
      },
      {
        "id" : "Coverage.subrogation",
        "path" : "Coverage.subrogation",
        "max" : "0"
      },
      {
        "id" : "Coverage.contract",
        "path" : "Coverage.contract",
        "max" : "0"
      }
    ]
  }
}

```
