# Indice Artefatti - HL7 Italia Terminology v0.1.2

* [**Table of Contents**](toc.md)
* **Indice Artefatti**

## Indice Artefatti

Questa pagina fornisce un elenco degli artefatti FHIR definiti in questa Implementation Guide.

### Terminology: CodeSystems

| | |
| :--- | :--- |
| [AIFA - ATC](CodeSystem-aifa-atc.md) | AIFA - ATC |
| [AIFA - Autorizzazione Immissione in Commercio](CodeSystem-aifa-aic.md) | AIFA - Autorizzazione Immissione in Commercio. |
| [AIFA - Farmaci equivalenti](CodeSystem-aifa-ge.md) | AIFA - Farmaci Equivalenti |
| [AIFA - Gruppo di equivalenza](CodeSystem-aifa-gruppo-equivalenza.md) | AIFA - Gruppo di equivalenza |
| [AIFA - Indicazioni terapeutiche (Nota AIFA)](CodeSystem-aifa-nota.md) | AIFA - Indicazioni terapeutiche per le quali un determinato farmaco è rimborsabile a carico del Servizio Sanitario Nazionale. Conosciute come Note AIFA |
| [HL7 Italia - AdministrativeGender (translation)](CodeSystem-administrative-gender.md) | HL7 Italia - Il genere di una persona, utilizzato per fini amministrativi. |
| [HL7 Italia - HL7 V3 RoleCode (estensione)](CodeSystem-it-V3RoleCode.md) | HL7 Italia - Estensione del Vocabolario HL7 V3 RoleCode |
| [HL7 Italia - Tipi di identificatore](CodeSystem-it-identifier-type.md) | HL7 Italia - Estensione (codici addizionali) alla tabella http://terminology.hl7.org/CodeSystem/v2-0203 per i tipi di identificatore |
| [HL7 Italia - Tipo di Entità](CodeSystem-it-tipoEntita.md) | HL7 Italia - Codifica delle diverse entità che hanno compiuto, compiono od intendono compiere un certo atto. Per esempio la certificazione di un record Paziente |
| [HL7 Italia - v3 Code System MaritalStatus (translation)](CodeSystem-v3-MaritalStatus.md) | HL7 Italia - v3 Code System MaritalStatus (translation) |
| [ISTAT - Classificazione dei titoli di studio italiani](CodeSystem-istat-ctsi03.md) | ISTAT - Classificazione dei titoli di studio italiani |
| [ISTAT - Classificazione delle professioni](CodeSystem-istat-professioni.md) | ISTAT - Classificazione delle professioni |
| [ISTAT - Comuni](CodeSystem-istat-comuni.md) | ISTAT - Comuni |
| [ISTAT - Continente](CodeSystem-istat-continente.md) | ISTAT - Continente |
| [ISTAT - Province](CodeSystem-province-istat.md) | ISTAT - Province |
| [ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG)](CodeSystem-dug.md) | ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) |
| [ISTAT - Ripartizione Geografica](CodeSystem-istat-ripartizione-geografica.md) | ISTAT - Codice Istat della Ripartizione geografica secondo la suddivisione del territorio nazionale |
| [ISTAT - Stato Civile](CodeSystem-istat-statoCivile.md) | ISTAT - Stato Civile |
| [ISTAT - Unita Amministrative Territoriali Estere](CodeSystem-istat-unitaAmministrativeTerritorialiEstere.md) | ISTAT - Unita Amministrative Territoriali Estere |
| [ISTAT - Unità Amministrative Territoriali](CodeSystem-istat-unitaAmministrativeTerritoriali.md) | ISTAT - Unità Amministrative Territoriali |
| [MDS - ASL](CodeSystem-cs-asl.md) | MDS - ASL |
| [MDS - Codici Regioni / PPAA](CodeSystem-minsan-regione.md) | MDS - Codici Regioni / PPAA |
| [MDS - Elenco Farmacie](CodeSystem-minsan-farmacie.md) | MDS - Elenco Farmacie |
| [MDS - Elenco Parafarmacie](CodeSystem-minsan-parafarmacie.md) | MDS - Elenco Parafarmacie |
| [MDS - Strutture di Ricovero](CodeSystem-minsan-hsp.md) | MDS - Strutture di Ricovero |
| [MDS - Strutture Interne di Ricovero](CodeSystem-cs-mds-idStruttureInterne.md) | MDS - Strutture Interne di Ricovero |
| [MDS - Tipologia Farmacia](CodeSystem-mds-tipologia-farmacia.md) | MDS - Tipologia Farmacia |
| [MDS - Tipologia Srutture di ricovero](CodeSystem-mds-tipo-struttura.md) | MDS - Tipologia Srutture di ricovero |
| [MDS - Esenzioni](CodeSystem-mds-esenzioni.md) | MDS - Esenzioni |

### Terminology: Valueset

| | |
| :--- | :--- |
| [AIFA - AIC](ValueSet-aifa-aic.md) | AIFA - Codice identificativo dei medicinali ad uso umano |
| [AIFA - Note](ValueSet-vs-aifa-nota.md) | AIFA - Indicazioni terapeutiche per un determinato farmaco rimborsabile dal Servizio Sanitario Nazionale |
| [Additivo Campione](ValueSet-additivo-campione-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione dell’additivo utilizzato per il campione di laboratorio. |
| [Anagrafi Regionali](ValueSet-vs-anagrafi-regionali.md) | Anagrafi Regionali |
| [Container Campione](ValueSet-campione-container-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del container del campione di laboratorio. |
| [EHIC Personal ID (system IDs - oid)](ValueSet-oid-ehicPersonalId.md) | Sistema di identificazione delle persone fisiche |
| [ISO 3166 - EHIC Country Codes](ValueSet-iso-ehicCountryCode.md) | Codifica geografica standardizzata |
| [ISTAT - Cittadinanza](ValueSet-istat-cittadinanza.md) | ISTAT - Cittadinanza |
| [ISTAT - Comune/Stato di Nascita](ValueSet-istat-luogoNascita.md) | ISTAT - Comune o Stato di nascita |
| [ISTAT - Comuni](ValueSet-istat-comune.md) | ISTAT - Comuni più sconosciuto |
| [ISTAT - DUG](ValueSet-istat-dug.md) | ISTAT - Registro delle Denominazioni Urbanistiche Generiche (DUG) |
| [ISTAT - Professioni](ValueSet-istat-professione.md) | ISTAT - Classificazione delle professioni |
| [ISTAT - Province](ValueSet-istat-provincia.md) | ISTAT - Province più sconosciuto |
| [ISTAT - Stati](ValueSet-istat-stato.md) | ISTAT - Stati |
| [ISTAT - Stato Civile](ValueSet-istat-statoCivile-vs.md) | ISTAT - Stato Civile |
| [ISTAT - Titolo Studio](ValueSet-istat-titoloStudio.md) | ISTAT - Titolo Studio |
| [Identificativi per codici STP regionali](ValueSet-URI-idStp.md) | Identificativi per codici STP regionali. |
| [Identificativi regionali per ASL (3 char)](ValueSet-uri-idAslRegione.md) | Identificativi regionali per ASL a 3 caratteri, come da file ministeriale |
| [MDS - Codici Regionali](ValueSet-minsan-regione.md) | MDS - Codici Regionali usati nei file FLS11. La regione Trentino Alto-Adige è rappresentata dalle province autonome di cui è composta. |
| [MDS - Codici strutture di ricovero pubbliche](ValueSet-strutturePubbliche.md) | MDS - Codici strutture di ricovero pubbliche |
| [MDS - Codici delle Strutture Interne](ValueSet-minsan-idStruttureInterne.md) | MDS - Codici delle Strutture Interne |
| [MDS - ID Aziende Ospedaliere](ValueSet-minsan-idAziendeOspedaliere.md) | MDS - Aziende Ospedaliere |
| [MDS - ID Aziende Ospedaliere Universitarie](ValueSet-minsan-idAou.md) | MDS - Azienda Ospedaliera integrata con l’Università |
| [MDS - Strutture Ricovero](ValueSet-minsan-idStrutture.md) | MDS - Strutture Ricovero |
| [Risultato osservazione codificato](ValueSet-valueset-valuecodeableconcept-obs-it.md) | Valueset contenente i codici per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato - presenza/assenza IPS di SNOMED CT](ValueSet-results-presence-absence-snomed-ct-ips-free-set.md) | Questo valueset include i codici per i risultati di presenza o assenza dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - Gruppo Sanguigno IPS di SNOMED CT](ValueSet-results-observation-bloodgroup.md) | Questo valueset include i codici per i risultati dei gruppi sanguigni dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato - microorganismo IPS di SNOMED CT](ValueSet-results-microorganism-snomed-ct-ips-free-set.md) | Questo valueset include i codici per i microrganismi dal sottoinsieme SNOMED International Patient Set (IPS) di SNOMED CT. |
| [Risultato osservazione codificato gruppo sanguigno](ValueSet-valueset-observation-value-bloodgroup.md) | Valueset contenente i codici SNOMED di gruppo sanguigno per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato microorganismi](ValueSet-valueset-observation-value-microorganism.md) | Valueset contenente i codici SNOMED di microorganismi per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Risultato osservazione codificato presenza/assenza](ValueSet-valueset-observation-value-presence-absence.md) | Valueset contenente i codici SNOMED di presenza/assenza per la risorsa Observation - Lab Report per la descrizione del risultato della rilevazione. |
| [Sezioni Composition Lab Report](ValueSet-sezione-referto-laboratorio.md) | Valueset contenente i codici LOINC per la specialità di laboratorio. |
| [Stato Civile](ValueSet-statoCivile.md) | Questo value set definisce una serie di codici per rappresentare lo stato civile di una persona. Specializza ed estende il value set http://hl7.org/fhir/ValueSet/marital-status |
| [Stato Esenzione](ValueSet-statoEsenzione.md) | Value Set basato sul vocabolario HL7 V3 ActStatus che descrive lo stato delle esenzioni. Questo value set è adottato da HL7 CDA R2 IG ‘DOCUMENTO DI ESENZIONE’ |
| [MDS - Esenzioni](ValueSet-vs-mds-esenzioni.md) | Valueset contenente i codici esenzione |
| [AIFA Gruppo di Equivalenza](ValueSet-aifa-ge.md) | AIFA - ValueSet gruppo di equivalenza |
| [HL7 Italia - HL7 V3 RoleCode (estensione)](ValueSet-vs-V3RoleCode.md) | ValueSet - estensione del Vocabolario HL7 V3 RoleCode |
| [Tipo Osservazione](ValueSet-risultato-osservazione.md) | Valueset contente i codici che identificano il tipo di osservazione nel referto di laboratorio. |
| [Tipo campione](ValueSet-tipo-campione-lab-it.md) | Valueset contenente i codici SNOMED per la risorsa Specimen - Lab Report per la descrizione del tipo di campione di laboratorio. |
| [Tipo certificatore](ValueSet-tipoCertificatore.md) | Tipo di Entità (organizzazione o persona) che ha certificato un certo record |
| [Tipo identificatore](ValueSet-VstipoIdentificatore.md) | Value set che descrivie i diversi tipi di identificatori. Include i codici della tabella http://terminology.hl7.org/CodeSystem/v2-0203 piu’ ‘STP’ ed ‘ENI’ |
| [Tipo medico di famiglia](ValueSet-mmgOrPls.md) | Tipo medico di famiglia: Medico Medicina Generale o Pediatra di Libera Scelta |
| [Tipo organizzazione (esempio)](ValueSet-tipoOrganizzazione.md) | Tipo di organizzazione: value set di esempio |
| [Tipo organizzazione socio-sanitaria](ValueSet-tipoOrgSocioSanitaria.md) | Tipo di organizzazione socio-sanitaria |
| [MDS - Elenco Farmacie](ValueSet-vs-mds-farmacia.md) | MDS - Elenco Farmacie |
| [WHO ATC](ValueSet-who-atc.md) | Sistema di classificazione anatomico, terapeutico e chimico per la classificazione sistematica dei farmaci |
| [WHO ICD-9-CM](ValueSet-who-icd9cm.md) | WHO ICD-9-CM |

### Terminology: Concept Maps 

| | |
| :--- | :--- |
| [Mapping fra VS HL7 e Tabella ISTAT Stato Civile](ConceptMap-ConceptMap-statoCivile.md) | Mapping da Value ‘statoCivile’ a Tabella Istat Stato Civile. |

